% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrf_put.R
\name{wrf_put}
\alias{wrf_put}
\title{Function to write variables in emission files}
\usage{
wrf_put(
  file = file.choose(),
  name = NA,
  POL,
  k,
  check = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{file}{Character; name of file interactively (default) or specified}

\item{name}{Character; name of the variable (any variable)}

\item{POL}{Numeric; emissions input or string/POSIXlt time}

\item{k}{Numeric; multiplier. If the length is more than 1, it multiplies POL for each
value of k. It can be used if you want to add an hourly profile to your emissions.}

\item{check}{logic (default is FALSE), TRUE to check for NA and negative values and replace with zeros}

\item{verbose}{display additional information}
}
\description{
Extract variable
}
\examples{
{
# create the folder and emission file
dir.create(file.path(tempdir(), "EMISS"))
wrf_create(wrfinput_dir = system.file("extdata", package = "eixport"),
          wrfchemi_dir = file.path(tempdir(), "EMISS"))

# get the name of created file
files <- list.files(path = file.path(tempdir(), "EMISS"),
                    pattern = "wrfchemi",
                    full.names = TRUE)

# open, put some numbers and write
CO <- wrf_get(file = files[1],
              name = "E_CO")

CO[] = rnorm(length(CO))

wrf_put(file = files[1],
        name = "E_CO",
        POL = CO)
}
}
\seealso{
\code{\link{wrf_plot}} and \code{\link{wrf_get}}
}
\author{
Daniel Schuch and Sergio Ibarra
}
