% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{MHI}
\alias{MHI}
\title{Modified Hypograph Index (MHI) for a functional dataset}
\usage{
MHI(curves, ...)
}
\arguments{
\item{curves}{\code{matrix} where each row represents a curve, and each column
represents values along the curve or an \code{array} with dimension
\eqn{n \times p \times q} with \eqn{n} curves, \eqn{p} values along the curve, and
\eqn{q} dimensions.}

\item{...}{Ignored.}
}
\value{
\code{numeric vector} containing the MHI for each curve.
}
\description{
The Modified Hypograph Index of a curve x is the proportion of "time"
the curves in the sample are below x.
}
\examples{
x <- matrix(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7), ncol = 3, nrow = 4)
MHI(x)
y <- array(c(1, 2, 3, 3, 2, 1, 5, 2, 3, 9, 8, 7, -1, -5, -6, 2, 3, 0, -1, 0, 2, -1, -2, 0),
  dim = c(3, 4, 2)
)
MHI(y)

}
