/*
    This file is part of rstanarm.
    Copyright (C) 2015, 2016 Trustees of Columbia University
    
    rstanarm is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rstanarm is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rstanarm.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_nb_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_nb : public prob_grad {
private:
    int J;
    vector<int> ystarraw;
    vector<int> CF;
public:
    model_nb(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_nb(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_nb_namespace::model_nb";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystarraw", "int", context__.to_vec(J));
        validate_non_negative_index("ystarraw", "J", J);
        ystarraw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystarraw");
        pos__ = 0;
        size_t ystarraw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystarraw_limit_0__; ++i_0__) {
            ystarraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "CF", "int", context__.to_vec(J));
        validate_non_negative_index("CF", "J", J);
        CF = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("CF");
        pos__ = 0;
        size_t CF_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < CF_limit_0__; ++i_0__) {
            CF[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += J;
    }

    ~model_nb() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("mui")))
            throw std::runtime_error("variable mui missing");
        vals_r__ = context__.vals_r("mui");
        pos__ = 0U;
        context__.validate_dims("initialization", "mui", "double", context__.to_vec(J));
        std::vector<double> mui(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mui[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mui[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mui: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        vector<T__> mui;
        size_t dim_mui_0__ = J;
        mui.reserve(dim_mui_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            if (jacobian__)
                mui.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mui.push_back(in__.scalar_lb_constrain(0));
        }


        // transformed parameters
        vector<T__> lambda(J);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambda,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 14;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 15;
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)));
            }
            current_statement_begin__ = 17;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambda[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 20;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 21;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 22;
            lp_accum__.add(gamma_log<propto__>(mui, kappa, kappamu));
            current_statement_begin__ = 23;
            lp_accum__.add(poisson_log<propto__>(ystarraw, lambda));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("mui");
        names__.push_back("lambda");
        names__.push_back("kappamu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_nb_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        vector<double> mui;
        size_t dim_mui_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            mui.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mui[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambda(J, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 14;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 15;
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)));
            }
            current_statement_begin__ = 17;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        vars__.push_back(kappamu);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_nb";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_paired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_paired : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_paired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_paired(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_paired_namespace::model_paired";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
        validate_non_negative_index("ystararaw", "J", J);
        ystararaw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystararaw");
        pos__ = 0;
        size_t ystararaw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
            ystararaw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
        validate_non_negative_index("ystarbraw", "J", J);
        ystarbraw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystarbraw");
        pos__ = 0;
        size_t ystarbraw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
            ystarbraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
        validate_non_negative_index("fpre", "J", J);
        fpre = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("fpre");
        pos__ = 0;
        size_t fpre_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
            fpre[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
        validate_non_negative_index("fpost", "J", J);
        fpost = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("fpost");
        pos__ = 0;
        size_t fpost_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
            fpost[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += J;
    }

    ~model_paired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(J));
        std::vector<double> mub(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        T__ delta;
        (void) delta;  // dummy to suppress unused var warning
        if (jacobian__)
            delta = in__.scalar_lub_constrain(0,1,lp__);
        else
            delta = in__.scalar_lub_constrain(0,1);

        vector<T__> mub;
        size_t dim_mub_0__ = J;
        mub.reserve(dim_mub_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            if (jacobian__)
                mub.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mub.push_back(in__.scalar_lb_constrain(0));
        }


        // transformed parameters
        vector<T__> lambdaa(J);
        vector<T__> lambdab(J);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambdaa,DUMMY_VAR__);
        stan::math::fill(lambdab,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 18;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 19;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 21;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 24;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambdaa[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambdab[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 27;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 28;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 29;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log(mub,kappa,kappamu));
            current_statement_begin__ = 31;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));
            current_statement_begin__ = 32;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
        names__.push_back("kappamu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_paired_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mub[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambdaa(J, 0.0);
        vector<double> lambdab(J, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 18;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 19;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 21;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 24;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
        }
        vars__.push_back(kappamu);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_paired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_unpaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_unpaired : public prob_grad {
private:
    int Ja;
    int Jb;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_unpaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_unpaired(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_unpaired_namespace::model_unpaired";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "Ja", "int", context__.to_vec());
        Ja = int(0);
        vals_i__ = context__.vals_i("Ja");
        pos__ = 0;
        Ja = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Jb", "int", context__.to_vec());
        Jb = int(0);
        vals_i__ = context__.vals_i("Jb");
        pos__ = 0;
        Jb = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(Ja));
        validate_non_negative_index("ystararaw", "Ja", Ja);
        ystararaw = std::vector<int>(Ja,int(0));
        vals_i__ = context__.vals_i("ystararaw");
        pos__ = 0;
        size_t ystararaw_limit_0__ = Ja;
        for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
            ystararaw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(Jb));
        validate_non_negative_index("ystarbraw", "Jb", Jb);
        ystarbraw = std::vector<int>(Jb,int(0));
        vals_i__ = context__.vals_i("ystarbraw");
        pos__ = 0;
        size_t ystarbraw_limit_0__ = Jb;
        for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
            ystarbraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(Ja));
        validate_non_negative_index("fpre", "Ja", Ja);
        fpre = std::vector<int>(Ja,int(0));
        vals_i__ = context__.vals_i("fpre");
        pos__ = 0;
        size_t fpre_limit_0__ = Ja;
        for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
            fpre[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(Jb));
        validate_non_negative_index("fpost", "Jb", Jb);
        fpost = std::vector<int>(Jb,int(0));
        vals_i__ = context__.vals_i("fpost");
        pos__ = 0;
        size_t fpost_limit_0__ = Jb;
        for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
            fpost[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += Jb;
        num_params_r__ += Ja;
    }

    ~model_unpaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(Jb));
        std::vector<double> mub(Jb,double(0));
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("mua")))
            throw std::runtime_error("variable mua missing");
        vals_r__ = context__.vals_r("mua");
        pos__ = 0U;
        context__.validate_dims("initialization", "mua", "double", context__.to_vec(Ja));
        std::vector<double> mua(Ja,double(0));
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            mua[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mua[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mua: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        T__ delta;
        (void) delta;  // dummy to suppress unused var warning
        if (jacobian__)
            delta = in__.scalar_lub_constrain(0,1,lp__);
        else
            delta = in__.scalar_lub_constrain(0,1);

        vector<T__> mub;
        size_t dim_mub_0__ = Jb;
        mub.reserve(dim_mub_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            if (jacobian__)
                mub.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mub.push_back(in__.scalar_lb_constrain(0));
        }

        vector<T__> mua;
        size_t dim_mua_0__ = Ja;
        mua.reserve(dim_mua_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            if (jacobian__)
                mua.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mua.push_back(in__.scalar_lb_constrain(0));
        }


        // transformed parameters
        vector<T__> lambdaa(Ja);
        vector<T__> lambdab(Jb);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning
        T__ kappamudelta;
        (void) kappamudelta;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambdaa,DUMMY_VAR__);
        stan::math::fill(lambdab,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);
        stan::math::fill(kappamudelta,DUMMY_VAR__);

        try {
            current_statement_begin__ = 21;
            for (int i = 1; i <= Jb; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 24;
            for (int i = 1; i <= Ja; ++i) {
                current_statement_begin__ = 25;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 27;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < Ja; ++i0__) {
            if (stan::math::is_uninitialized(lambdaa[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < Jb; ++i0__) {
            if (stan::math::is_uninitialized(lambdab[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }
        if (stan::math::is_uninitialized(kappamudelta)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamudelta";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 31;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 32;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 33;
            lp_accum__.add((gamma_log(mub,kappa,kappamu) + gamma_log(mua,kappa,kappamu)));
            current_statement_begin__ = 34;
            lp_accum__.add(poisson_log<propto__>(ystarbraw, lambdab));
            current_statement_begin__ = 35;
            lp_accum__.add(poisson_log<propto__>(ystararaw, lambdaa));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("mua");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
        names__.push_back("kappamu");
        names__.push_back("kappamudelta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_unpaired_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = Jb;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> mua;
        size_t dim_mua_0__ = Ja;
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            mua.push_back(in__.scalar_lb_constrain(0));
        }
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
        for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(mub[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(mua[k_0__]);
        }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambdaa(Ja, 0.0);
        vector<double> lambdab(Jb, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning
        double kappamudelta(0.0);
        (void) kappamudelta;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 21;
            for (int i = 1; i <= Jb; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 24;
            for (int i = 1; i <= Ja; ++i) {
                current_statement_begin__ = 25;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 27;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
        }
        vars__.push_back(kappamu);
        vars__.push_back(kappamudelta);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_unpaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamudelta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamudelta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_zinb_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_zinb : public prob_grad {
private:
    int J;
    vector<int> ystarraw;
    vector<int> CF;
public:
    model_zinb(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_zinb(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_zinb_namespace::model_zinb";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystarraw", "int", context__.to_vec(J));
        validate_non_negative_index("ystarraw", "J", J);
        ystarraw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystarraw");
        pos__ = 0;
        size_t ystarraw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystarraw_limit_0__; ++i_0__) {
            ystarraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "CF", "int", context__.to_vec(J));
        validate_non_negative_index("CF", "J", J);
        CF = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("CF");
        pos__ = 0;
        size_t CF_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < CF_limit_0__; ++i_0__) {
            CF[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += J;
        ++num_params_r__;
    }

    ~model_zinb() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("mui")))
            throw std::runtime_error("variable mui missing");
        vals_r__ = context__.vals_r("mui");
        pos__ = 0U;
        context__.validate_dims("initialization", "mui", "double", context__.to_vec(J));
        std::vector<double> mui(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mui[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mui[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mui: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        vector<T__> mui;
        size_t dim_mui_0__ = J;
        mui.reserve(dim_mui_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            if (jacobian__)
                mui.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mui.push_back(in__.scalar_lb_constrain(0));
        }

        T__ phi;
        (void) phi;  // dummy to suppress unused var warning
        if (jacobian__)
            phi = in__.scalar_lub_constrain(0,1,lp__);
        else
            phi = in__.scalar_lub_constrain(0,1);


        // transformed parameters
        vector<T__> lambda(J);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambda,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 15;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)));
            }
            current_statement_begin__ = 18;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambda[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 21;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 22;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 23;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 24;
            lp_accum__.add(gamma_log<propto__>(mui, kappa, kappamu));
            current_statement_begin__ = 25;
            for (int n = 1; n <= J; ++n) {
                current_statement_begin__ = 26;
                if (as_bool(logical_eq(get_base1(ystarraw,n,"ystarraw",1),0))) {
                    current_statement_begin__ = 27;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarraw,n,"ystarraw",1),get_base1(lambda,n,"lambda",1)))));
                } else {
                    current_statement_begin__ = 29;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarraw,n,"ystarraw",1),get_base1(lambda,n,"lambda",1))));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("mui");
        names__.push_back("phi");
        names__.push_back("lambda");
        names__.push_back("kappamu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_zinb_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        vector<double> mui;
        size_t dim_mui_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mui_0__; ++k_0__) {
            mui.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mui[k_0__]);
        }
        vars__.push_back(phi);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambda(J, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 15;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 16;
                stan::math::assign(get_base1_lhs(lambda,i,"lambda",1), (get_base1(mui,i,"mui",1) / get_base1(CF,i,"CF",1)));
            }
            current_statement_begin__ = 18;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambda[k_0__]);
        }
        vars__.push_back(kappamu);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_zinb";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mui" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_zipaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_zipaired : public prob_grad {
private:
    int J;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpre;
    vector<int> fpost;
public:
    model_zipaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_zipaired(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_zipaired_namespace::model_zipaired";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "J", "int", context__.to_vec());
        J = int(0);
        vals_i__ = context__.vals_i("J");
        pos__ = 0;
        J = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(J));
        validate_non_negative_index("ystararaw", "J", J);
        ystararaw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystararaw");
        pos__ = 0;
        size_t ystararaw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
            ystararaw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(J));
        validate_non_negative_index("ystarbraw", "J", J);
        ystarbraw = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("ystarbraw");
        pos__ = 0;
        size_t ystarbraw_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
            ystarbraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(J));
        validate_non_negative_index("fpre", "J", J);
        fpre = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("fpre");
        pos__ = 0;
        size_t fpre_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
            fpre[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(J));
        validate_non_negative_index("fpost", "J", J);
        fpost = std::vector<int>(J,int(0));
        vals_i__ = context__.vals_i("fpost");
        pos__ = 0;
        size_t fpost_limit_0__ = J;
        for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
            fpost[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += J;
        ++num_params_r__;
    }

    ~model_zipaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(J));
        std::vector<double> mub(J,double(0));
        for (int i0__ = 0U; i0__ < J; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < J; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        T__ delta;
        (void) delta;  // dummy to suppress unused var warning
        if (jacobian__)
            delta = in__.scalar_lub_constrain(0,1,lp__);
        else
            delta = in__.scalar_lub_constrain(0,1);

        vector<T__> mub;
        size_t dim_mub_0__ = J;
        mub.reserve(dim_mub_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            if (jacobian__)
                mub.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mub.push_back(in__.scalar_lb_constrain(0));
        }

        T__ phi;
        (void) phi;  // dummy to suppress unused var warning
        if (jacobian__)
            phi = in__.scalar_lub_constrain(0,1,lp__);
        else
            phi = in__.scalar_lub_constrain(0,1);


        // transformed parameters
        vector<T__> lambdaa(J);
        vector<T__> lambdab(J);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambdaa,DUMMY_VAR__);
        stan::math::fill(lambdab,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 19;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 20;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
                current_statement_begin__ = 21;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 23;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambdaa[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < J; ++i0__) {
            if (stan::math::is_uninitialized(lambdab[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 26;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 27;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 28;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 29;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, kappamu));
            current_statement_begin__ = 31;
            for (int n = 1; n <= J; ++n) {
                current_statement_begin__ = 32;
                if (as_bool(logical_eq(get_base1(ystarbraw,n,"ystarbraw",1),0))) {
                    current_statement_begin__ = 33;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1)))));
                } else {
                    current_statement_begin__ = 35;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1))));
                }
            }
            current_statement_begin__ = 37;
            for (int n = 1; n <= J; ++n) {
                current_statement_begin__ = 38;
                if (as_bool(logical_eq(get_base1(ystararaw,n,"ystararaw",1),0))) {
                    current_statement_begin__ = 39;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1)))));
                } else {
                    current_statement_begin__ = 41;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1))));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mub");
        names__.push_back("phi");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
        names__.push_back("kappamu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(J);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_zipaired_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mub;
        size_t dim_mub_0__ = J;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(mub[k_0__]);
        }
        vars__.push_back(phi);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambdaa(J, 0.0);
        vector<double> lambdab(J, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 19;
            for (int i = 1; i <= J; ++i) {
                current_statement_begin__ = 20;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
                current_statement_begin__ = 21;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mub,i,"mub",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 23;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < J; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
        }
        vars__.push_back(kappamu);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_zipaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= J; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




// Code generated by Stan version 2.11

#include <stan/model/model_header.hpp>

namespace model_ziunpaired_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

class model_ziunpaired : public prob_grad {
private:
    int Ja;
    int Jb;
    vector<int> ystararaw;
    vector<int> ystarbraw;
    vector<int> fpost;
    vector<int> fpre;
public:
    model_ziunpaired(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        typedef boost::ecuyer1988 rng_t;
        rng_t base_rng(0);  // 0 seed default
        ctor_body(context__, base_rng, pstream__);
    }

    template <class RNG>
    model_ziunpaired(stan::io::var_context& context__,
        RNG& base_rng__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, base_rng__, pstream__);
    }

    template <class RNG>
    void ctor_body(stan::io::var_context& context__,
                   RNG& base_rng__,
                   std::ostream* pstream__) {
        current_statement_begin__ = -1;

        static const char* function__ = "model_ziunpaired_namespace::model_ziunpaired";
        (void) function__; // dummy call to supress warning
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        context__.validate_dims("data initialization", "Ja", "int", context__.to_vec());
        Ja = int(0);
        vals_i__ = context__.vals_i("Ja");
        pos__ = 0;
        Ja = vals_i__[pos__++];
        context__.validate_dims("data initialization", "Jb", "int", context__.to_vec());
        Jb = int(0);
        vals_i__ = context__.vals_i("Jb");
        pos__ = 0;
        Jb = vals_i__[pos__++];
        context__.validate_dims("data initialization", "ystararaw", "int", context__.to_vec(Ja));
        validate_non_negative_index("ystararaw", "Ja", Ja);
        ystararaw = std::vector<int>(Ja,int(0));
        vals_i__ = context__.vals_i("ystararaw");
        pos__ = 0;
        size_t ystararaw_limit_0__ = Ja;
        for (size_t i_0__ = 0; i_0__ < ystararaw_limit_0__; ++i_0__) {
            ystararaw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "ystarbraw", "int", context__.to_vec(Jb));
        validate_non_negative_index("ystarbraw", "Jb", Jb);
        ystarbraw = std::vector<int>(Jb,int(0));
        vals_i__ = context__.vals_i("ystarbraw");
        pos__ = 0;
        size_t ystarbraw_limit_0__ = Jb;
        for (size_t i_0__ = 0; i_0__ < ystarbraw_limit_0__; ++i_0__) {
            ystarbraw[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpost", "int", context__.to_vec(Ja));
        validate_non_negative_index("fpost", "Ja", Ja);
        fpost = std::vector<int>(Ja,int(0));
        vals_i__ = context__.vals_i("fpost");
        pos__ = 0;
        size_t fpost_limit_0__ = Ja;
        for (size_t i_0__ = 0; i_0__ < fpost_limit_0__; ++i_0__) {
            fpost[i_0__] = vals_i__[pos__++];
        }
        context__.validate_dims("data initialization", "fpre", "int", context__.to_vec(Jb));
        validate_non_negative_index("fpre", "Jb", Jb);
        fpre = std::vector<int>(Jb,int(0));
        vals_i__ = context__.vals_i("fpre");
        pos__ = 0;
        size_t fpre_limit_0__ = Jb;
        for (size_t i_0__ = 0; i_0__ < fpre_limit_0__; ++i_0__) {
            fpre[i_0__] = vals_i__[pos__++];
        }

        // validate data

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed data

        // set parameter ranges
        num_params_r__ = 0U;
        param_ranges_i__.clear();
        ++num_params_r__;
        ++num_params_r__;
        ++num_params_r__;
        num_params_r__ += Ja;
        num_params_r__ += Jb;
        ++num_params_r__;
    }

    ~model_ziunpaired() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("kappa")))
            throw std::runtime_error("variable kappa missing");
        vals_r__ = context__.vals_r("kappa");
        pos__ = 0U;
        context__.validate_dims("initialization", "kappa", "double", context__.to_vec());
        double kappa(0);
        kappa = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,kappa);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable kappa: ") + e.what());
        }

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0,mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("delta")))
            throw std::runtime_error("variable delta missing");
        vals_r__ = context__.vals_r("delta");
        pos__ = 0U;
        context__.validate_dims("initialization", "delta", "double", context__.to_vec());
        double delta(0);
        delta = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,delta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable delta: ") + e.what());
        }

        if (!(context__.contains_r("mua")))
            throw std::runtime_error("variable mua missing");
        vals_r__ = context__.vals_r("mua");
        pos__ = 0U;
        context__.validate_dims("initialization", "mua", "double", context__.to_vec(Ja));
        std::vector<double> mua(Ja,double(0));
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            mua[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Ja; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mua[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mua: ") + e.what());
        }

        if (!(context__.contains_r("mub")))
            throw std::runtime_error("variable mub missing");
        vals_r__ = context__.vals_r("mub");
        pos__ = 0U;
        context__.validate_dims("initialization", "mub", "double", context__.to_vec(Jb));
        std::vector<double> mub(Jb,double(0));
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            mub[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < Jb; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,mub[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mub: ") + e.what());
        }

        if (!(context__.contains_r("phi")))
            throw std::runtime_error("variable phi missing");
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        context__.validate_dims("initialization", "phi", "double", context__.to_vec());
        double phi(0);
        phi = vals_r__[pos__++];
        try {
            writer__.scalar_lub_unconstrain(0,1,phi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable phi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        // model parameters
        stan::io::reader<T__> in__(params_r__,params_i__);

        T__ kappa;
        (void) kappa;  // dummy to suppress unused var warning
        if (jacobian__)
            kappa = in__.scalar_lb_constrain(0,lp__);
        else
            kappa = in__.scalar_lb_constrain(0);

        T__ mu;
        (void) mu;  // dummy to suppress unused var warning
        if (jacobian__)
            mu = in__.scalar_lb_constrain(0,lp__);
        else
            mu = in__.scalar_lb_constrain(0);

        T__ delta;
        (void) delta;  // dummy to suppress unused var warning
        if (jacobian__)
            delta = in__.scalar_lub_constrain(0,1,lp__);
        else
            delta = in__.scalar_lub_constrain(0,1);

        vector<T__> mua;
        size_t dim_mua_0__ = Ja;
        mua.reserve(dim_mua_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            if (jacobian__)
                mua.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mua.push_back(in__.scalar_lb_constrain(0));
        }

        vector<T__> mub;
        size_t dim_mub_0__ = Jb;
        mub.reserve(dim_mub_0__);
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            if (jacobian__)
                mub.push_back(in__.scalar_lb_constrain(0,lp__));
            else
                mub.push_back(in__.scalar_lb_constrain(0));
        }

        T__ phi;
        (void) phi;  // dummy to suppress unused var warning
        if (jacobian__)
            phi = in__.scalar_lub_constrain(0,1,lp__);
        else
            phi = in__.scalar_lub_constrain(0,1);


        // transformed parameters
        vector<T__> lambdaa(Ja);
        vector<T__> lambdab(Jb);
        T__ kappamu;
        (void) kappamu;  // dummy to suppress unused var warning

        // initialize transformed variables to avoid seg fault on val access
        stan::math::fill(lambdaa,DUMMY_VAR__);
        stan::math::fill(lambdab,DUMMY_VAR__);
        stan::math::fill(kappamu,DUMMY_VAR__);

        try {
            current_statement_begin__ = 21;
            for (int i = 1; i <= Jb; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 24;
            for (int i = 1; i <= Ja; ++i) {
                current_statement_begin__ = 25;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 27;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters
        for (int i0__ = 0; i0__ < Ja; ++i0__) {
            if (stan::math::is_uninitialized(lambdaa[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdaa" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        for (int i0__ = 0; i0__ < Jb; ++i0__) {
            if (stan::math::is_uninitialized(lambdab[i0__])) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambdab" << '[' << i0__ << ']';
                throw std::runtime_error(msg__.str());
            }
        }
        if (stan::math::is_uninitialized(kappamu)) {
            std::stringstream msg__;
            msg__ << "Undefined transformed parameter: kappamu";
            throw std::runtime_error(msg__.str());
        }

        const char* function__ = "validate transformed params";
        (void) function__;  // dummy to suppress unused var warning

        // model body
        try {
            current_statement_begin__ = 30;
            lp_accum__.add(gamma_log<propto__>(mu, 1, 0.001));
            current_statement_begin__ = 31;
            lp_accum__.add(gamma_log<propto__>(kappa, 1, 0.69999999999999996));
            current_statement_begin__ = 32;
            lp_accum__.add(beta_log<propto__>(delta, 1, 1));
            current_statement_begin__ = 33;
            lp_accum__.add(beta_log<propto__>(phi, 1, 1));
            current_statement_begin__ = 50;
            lp_accum__.add(gamma_log<propto__>(mub, kappa, kappamu));
            current_statement_begin__ = 51;
            lp_accum__.add(gamma_log<propto__>(mua, kappa, kappamu));
            current_statement_begin__ = 52;
            for (int n = 1; n <= Jb; ++n) {
                current_statement_begin__ = 53;
                if (as_bool(logical_eq(get_base1(ystarbraw,n,"ystarbraw",1),0))) {
                    current_statement_begin__ = 54;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1)))));
                } else {
                    current_statement_begin__ = 56;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystarbraw,n,"ystarbraw",1),get_base1(lambdab,n,"lambdab",1))));
                }
            }
            current_statement_begin__ = 58;
            for (int n = 1; n <= Ja; ++n) {
                current_statement_begin__ = 59;
                if (as_bool(logical_eq(get_base1(ystararaw,n,"ystararaw",1),0))) {
                    current_statement_begin__ = 60;
                    lp_accum__.add(log_sum_exp(bernoulli_log(1,phi),(bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1)))));
                } else {
                    current_statement_begin__ = 62;
                    lp_accum__.add((bernoulli_log(0,phi) + poisson_log(get_base1(ystararaw,n,"ystararaw",1),get_base1(lambdaa,n,"lambdaa",1))));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("kappa");
        names__.push_back("mu");
        names__.push_back("delta");
        names__.push_back("mua");
        names__.push_back("mub");
        names__.push_back("phi");
        names__.push_back("lambdaa");
        names__.push_back("lambdab");
        names__.push_back("kappamu");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Ja);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Jb);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ziunpaired_namespace::write_array";
        (void) function__; // dummy call to supress warning
        // read-transform, write parameters
        double kappa = in__.scalar_lb_constrain(0);
        double mu = in__.scalar_lb_constrain(0);
        double delta = in__.scalar_lub_constrain(0,1);
        vector<double> mua;
        size_t dim_mua_0__ = Ja;
        for (size_t k_0__ = 0; k_0__ < dim_mua_0__; ++k_0__) {
            mua.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> mub;
        size_t dim_mub_0__ = Jb;
        for (size_t k_0__ = 0; k_0__ < dim_mub_0__; ++k_0__) {
            mub.push_back(in__.scalar_lb_constrain(0));
        }
        double phi = in__.scalar_lub_constrain(0,1);
        vars__.push_back(kappa);
        vars__.push_back(mu);
        vars__.push_back(delta);
        for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(mua[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(mub[k_0__]);
        }
        vars__.push_back(phi);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__; // dummy call to supress warning
        stan::math::accumulator<double> lp_accum__;

        vector<double> lambdaa(Ja, 0.0);
        vector<double> lambdab(Jb, 0.0);
        double kappamu(0.0);
        (void) kappamu;  // dummy to suppress unused var warning

        try {
            current_statement_begin__ = 21;
            for (int i = 1; i <= Jb; ++i) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(lambdab,i,"lambdab",1), (get_base1(mub,i,"mub",1) / get_base1(fpre,i,"fpre",1)));
            }
            current_statement_begin__ = 24;
            for (int i = 1; i <= Ja; ++i) {
                current_statement_begin__ = 25;
                stan::math::assign(get_base1_lhs(lambdaa,i,"lambdaa",1), ((delta * get_base1(mua,i,"mua",1)) / get_base1(fpost,i,"fpost",1)));
            }
            current_statement_begin__ = 27;
            stan::math::assign(kappamu, (kappa / mu));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate transformed parameters

        // write transformed parameters
        for (int k_0__ = 0; k_0__ < Ja; ++k_0__) {
            vars__.push_back(lambdaa[k_0__]);
        }
        for (int k_0__ = 0; k_0__ < Jb; ++k_0__) {
            vars__.push_back(lambdab[k_0__]);
        }
        vars__.push_back(kappamu);

        if (!include_gqs__) return;
        // declare and define generated quantities

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning


        // initialize transformed variables to avoid seg fault on val access

        try {
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e,current_statement_begin__);
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        // validate generated quantities

        // write generated quantities
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ziunpaired";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappa";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "delta";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mua" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mub" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "phi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= Ja; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdaa" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= Jb; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambdab" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "kappamu";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__) return;
    }

}; // model

} // namespace




#endif
