% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{create_variable_definition_dataframe}
\alias{create_variable_definition_dataframe}
\title{Create a variables definition data frame}
\usage{
create_variable_definition_dataframe(variable_names,
  long_names = variable_names, standard_names = variable_names,
  units = "mm", missval = -9999, precision = "double", dimensions = 4L,
  var_attributes = create_var_attribute_definition())
}
\arguments{
\item{variable_names}{character vector, names of the variables}

\item{long_names}{character vector, long names of the variables (defaults to variable_names if missing)}

\item{standard_names}{character vector, standard names of the variables (optional, defaults to variable_names)}

\item{units}{character vector, units for the variable(s)}

\item{missval}{numeric vector, missing value code(s) for the variable(s)}

\item{precision}{character vector, precision of the variables}

\item{dimensions}{character or integer vector, number of dimensions each variable (2, 3 or 4)}

\item{var_attributes}{a list of named attributes. See \code{\link{create_var_attribute_definition}}}
}
\value{
a data frame suitable for \code{\link{create_variable_definition}}
}
\description{
Create a variable definition usable by the function \code{\link{create_variable_definitions}} 
to create netCDF variables. The use of this function is not compulsory to create a EFTS 
netCDF schema, just offered as a convenience.
}
\seealso{
See
   \code{\link{create_variable_definition}} and \code{\link{create_efts}} for examples
}
