% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.fusion}
\alias{plot.fusion}
\title{Plot an object of class \code{fusion}}
\usage{
\method{plot}{fusion}(x, maxPlots = 4, ...)
}
\arguments{
\item{x}{an object of class \code{fusion}}

\item{maxPlots}{maximum number of plots on a single page, default argument to 4}

\item{...}{further arguments passed to or from other methods (not used)}
}
\description{
This function provides plots of posterior means and 95\%-HPD intervals for the
regression effects. Plots are based on the refitted MCMC samples of the
selected model in an object of class \code{fusion} or on model averaged results if no
final model selection was performed.
}
\details{
If no effect fusion or no final model selection is performed, posterior means and HPD intervals are model averaged
results. Otherwise, the parameters of the selected model are reestimated
with a flat uninformative prior. Thus, fused categories have the same posterior mean and HPD interval. Single categories that are excluded
from the model are fused to the reference category and therefore only a posterior mean at zero and no
interval is plotted.
}
\examples{
## see example for effectFusion
}
\seealso{
\code{\link{effectFusion}}
}
\author{
Daniela Pauger, Magdalena Leitner <magdalena.leitner@jku.at>
}
