% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{tcp01}
\alias{tcp01}
\alias{tcp04}
\alias{tcp07}
\alias{tcp10}
\alias{tcp13}
\alias{tcp16}
\alias{tcp19}
\title{Two candidate preferred votes for candidates 
(House of Representatives) in each electorate.}
\format{
A data frame with the following variables:

\strong{For the 2001 election:}

\describe{
    \item{UniqueID}{Numeric identifier that links the electoral division with Census  
    and other election datasets}
    \item{StateAb}{Abbreviation for state name}  
    \item{DivisionNm}{Electoral division name}             
    \item{Surname}{Candidate surname}          
    \item{GivenNm}{Candidate given name}
    \item{Elected}{Whether the candidate was elected (Y/N)}
    \item{Percent}{Percentage of ordinary votes cast for the candidate}
    \item{PartyAb}{Abbreviation for political party name}         
    \item{PartyNm}{Political party name}    
    \item{Swing}{Percentage point change in ordinary votes for the party from the previous election}     
    }

\strong{For the 2004 election:}

\describe{
    \item{StateAb}{Abbreviation for state name}  
    \item{UniqueID}{Numeric identifier that links the electoral division with Census
    and other election datasets.}
    \item{DivisionNm}{Electoral division name}
    \item{BallotPosition}{Candidate's position on the ballot}
    \item{CandidateID}{Candidate ID}
    \item{Surname}{Candidate surname}
    \item{GivenNm}{Candidate given name}
    \item{PartyAb}{Abbreviation for political party name}
    \item{PartyNm}{Political party name}
    \item{Elected}{Whether the candidate was elected (Y/N)}
    \item{OrdinaryVotes}{Number of ordinary votes cast for the candidate}
    \item{Percent}{Percentage of ordinary votes cast for the candidate}
    }

\strong{For the 2007 election onwards:}
\describe{
\item{StateAb}{Abbreviation for state name}
\item{UniqueID}{Numeric identifier that links the electoral division with Census
and other election datasets.}
\item{DivisionNm}{Electoral division name}
\item{BallotPosition}{Candidate's position on the ballot}
\item{CandidateID}{Candidate ID}
\item{Surname}{Candidate surname}
\item{GivenNm}{Candidate given name}
\item{PartyAb}{Abbreviation for political party name}
\item{PartyNm}{Political party name}
\item{Elected}{Whether the candidate was elected (Y/N)}
\item{HistoricElected}{Whether the candidate is the incumbent member}
\item{OrdinaryVotes}{Number of ordinary votes cast for the candidate}
\item{Percent}{Percentage of ordinary votes cast for the candidate}
}

{}

{}

{}

{}
}
\source{
\url{https://www.aec.gov.au/About_AEC/Publications/statistics/files/aec-2001-election-statistics.zip}.

\url{https://results.aec.gov.au/12246/results/HouseDownloadsMenu-12246-csv.htm}

\url{https://www.aec.gov.au/elections/federal_elections/2004/downloads.htm}.

\url{https://results.aec.gov.au/13745/Website/HouseDownloadsMenu-13745-csv.htm}

\url{https://www.aec.gov.au/elections/federal_elections/2007/downloads.htm}.

\url{https://results.aec.gov.au/15508/Website/HouseDownloadsMenu-15508-csv.htm}

\url{https://www.aec.gov.au/elections/federal_elections/2010/downloads.htm}

\url{https://results.aec.gov.au/17496/Website/HouseDownloadsMenu-17496-csv.htm}

\url{https://www.aec.gov.au/elections/federal_elections/2013/downloads.htm}

\url{https://results.aec.gov.au/20499/Website/HouseDownloadsMenu-20499-csv.htm}

\url{https://www.aec.gov.au/elections/federal_elections/2016/downloads.htm}

\url{https://results.aec.gov.au/24310/Website/HouseDownloadsMenu-24310-Csv.htm}
}
\usage{
tcp01

tcp04

tcp07

tcp10

tcp13

tcp16

tcp19
}
\description{
A dataset containing two candidate preferred vote counts, 
and other results for the House of Representatives from the 
2001 to 2019 Australian federal elections. 
Includes the count of votes for the leading two candidates 
in the electorate after distribution of preferences.
}
\keyword{datasets}
