% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nat_data}
\alias{nat_data}
\title{Data of the Australian Electorate from 2013}
\format{A data frame with 150 rows with the following variables:
\itemize{
    \item id: numeric identifier that links the electorate with the corresponding polygon in `nat_map`.
    \item ELECT_DIV: Electorate division name   
    \item STATE: abbreviation of the state name
    \item NUMCCDS: AEC variable that might be filled with meaning or a description down the road
    \item AREA_SQKM: combined square kilometers of each electorate
}}
\usage{
nat_data
}
\description{
A dataset containing some demographic information for each of the 150 Australian electorates.
The data were obtained from the Australian Electoral Commission, and downloaded 
from \url{http://www.aec.gov.au/Electorates/gis/gis_datadownload.htm}.
The data is published
}
\examples{

data(nat_data)
nat_map$region <- nat_map$ELECT_DIV
data(abs2011)
abs2011$region <- abs2011$Electorate
both <- intersect(unique(abs2011$region), unique(nat_map$region))
data(nat_data)
library(ggplot2)
library(ggthemes)
ggplot(aes(map_id=region), data=subset(abs2011, region \%in\% both)) +
  geom_map(aes(fill=MedianIncome), map=subset(nat_map, region \%in\% both)) +
  expand_limits(x=nat_map$long, y=nat_map$lat) + 
  theme_map()
  
}
\keyword{datasets}
