% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixOperators.R
\name{gram2edm}
\alias{gram2edm}
\title{Linear Matrix Operator}
\usage{
gram2edm(B)
}
\arguments{
\item{B}{A centered, positive semi-definite matrix.}
}
\value{
D A matrix in \eqn{D_{n}^{-}}. If the input matrix B is a gram matrix, D is a Euclidean Distance Matrix.
}
\description{
\code{gram2edm} Inverse Operator of edm2gram
}
\details{
The edm2gram function performs the following transformation:

\deqn{edm2gram(D_{n}^{-}) = B_{n}^{+}} 

where \eqn{D_{n}^{-}} is the space of symmetric, hollow matrices, negative definite on the space spanned by \eqn{x'e = 0}
and \eqn{B_{n}^{+}} is the space of centered positive definite matrices. 

The gram2edm function performs the inverse operation, taking a matrix in \eqn{B_{n}^{+}} and transforming it to a matrix in \eqn{D_{n}^{-}}.

\deqn{gram2edm(B_{n}^{+}) = D_{n}^{-}}

Therfore, gram2edm on \eqn{B_{n}^{+}} is the inverse operator of edm2gram on \eqn{D_{n}^{-}}.
}
\examples{
 
X <- cbind(runif(100,0,1),runif(100,0,1))
G <- X \%*\% t(X)
gram2edm(G)

}
\seealso{
\code{\link{edm2gram}}
}
