% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allot.R
\name{allot_trts}
\alias{allot_trts}
\title{Define allotment of treatments to units}
\usage{
allot_trts(.edibble, ..., .record = TRUE)
}
\arguments{
\item{.edibble}{An edibble design which should have units, treatments and allotment defined.}

\item{...}{One-sided or two-sided formula. If the input is a one-sided formula
then the whole treatment is applied to the specified unit.}

\item{.record}{Whether to record the step.}
}
\value{
Return an edibble design.
}
\description{
This function adds the edges between factor nodes to describe the
high-level relationship between factors.
This function does not actually assign edges between level nodes.
}
\examples{
design() \%>\%
  set_units(block = 10,
            plot = nested_in(block, 3)) \%>\%
  set_trts(treat = c("A", "B", "C"),
           pest = c("a", "b")) \%>\%
  allot_trts(treat ~ plot,
              pest ~ block)

}
\seealso{
assign

Other user-facing functions: 
\code{\link{allot_units}()},
\code{\link{design}()},
\code{\link{expect_rcrds}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
