% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilingInfo.R
\name{getFilingInfo}
\alias{getFilingInfo}
\title{Retrieves filing information of a firm}
\usage{
getFilingInfo(firm.identifier, filing.year, quarter, form.type)
}
\arguments{
\item{firm.identifier}{CIK of a firm in integer format or full/partial 
name of a firm in character format. Suppress leading zeroes from CIKs.}

\item{filing.year}{vector of integer containing filing years.}

\item{quarter}{vector of one digit integer quarter number. By default, it is 
considered as all the quarters, quarter =c(1, 2, 3, 4).}

\item{form.type}{vector of form types in character format. By default, it is kept
as all the available form types.}
}
\value{
Function returns dataframe with filing information.
}
\description{
\code{getFilingInfo} retrieves filing information of a firm based on its name or cik.
}
\details{
getFilingInfo function takes firm identifier (name or cik), filing year(s), quarter(s), 
and form type as input parameters from a user and provides filing information for the 
firm. The function automatically downloads master index for the input year(s) and 
the quarter(s) using \link[edgar]{getMasterIndex} function if it is not already 
been downloaded in the current working directory. By default, information of all 
the form types filed in all the quarters of the input year by the firm will be 
provided by this function.
}
\examples{
\dontrun{

info <- getFilingInfo('United Technologies', c(2005, 2006), 
                       quarter = c(1,2), form.type = c('8-K','10-K')) 
## Returns filing information on '8-K' and '10-K' filed by the firm 
in quarter 1 and 2 of year 2005 and 2006.

info <- getFilingInfo(1067701, 2006) 
## Returns all the filings information filed by the firm in all 
the quarters of year 2006.
}
}
