% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_lifecycle_trim.R
\name{filter_trim_lifecycle}
\alias{filter_trim_lifecycle}
\alias{filter_trim_lifecycle.eventlog}
\alias{filter_trim_lifecycle.grouped_eventlog}
\alias{ifilter_trim_lifecycle}
\title{Filter: Trim activity instances based on life cycle labels}
\usage{
filter_trim_lifecycle(eventlog, start_lifecycle, end_lifecycle, reverse)

\method{filter_trim_lifecycle}{eventlog}(eventlog,
  start_lifecycle = NULL, end_lifecycle = NULL, reverse = FALSE)

\method{filter_trim_lifecycle}{grouped_eventlog}(eventlog,
  start_lifecycle = NULL, end_lifecycle = NULL, reverse = FALSE)

ifilter_trim_lifecycle(eventlog)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.}

\item{start_lifecycle}{A vector of life cycle identifiers, or NULL}

\item{end_lifecycle}{A vector of life cycle identifiers, or NULL}

\item{reverse}{Logical, indicating whether the selection should be reversed.}
}
\value{
When given an eventlog, it will return a filtered eventlog. When given a grouped eventlog, the filter will be applied
in a stratified way (i.e. each separately for each group). The returned eventlog will be grouped on the same variables as
the original event log.
}
\description{
Trim activity instances from the first event of a set of start life cycle labels to the last event of a set of end life cycle labels
}
\details{
One can trim activity instances  by removing one or more events at the start and/or end of the activity instances.
Trimming is performed until all activity instances have a start and/or
end point belonging to a set of allowed life cycle labels. This filter requires a set of allowed
start life cycle labels and/or a set of allowed life cycle labels. If one of them is not provided it will
not trim the activity instances at this edge.The selection can be reversed, which means that
only the trimmed events at the start and end of activity instances are retained. As such, this argument
allows to cut intermediate parts out of activity instances.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Filter event log

\item \code{grouped_eventlog}: Filter grouped event log
}}

\seealso{
\code{vignette("filters", "edeaR")}
}
