% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_presence.R
\name{activity_presence}
\alias{activity_presence}
\alias{activity_presence.eventlog}
\alias{activity_presence.grouped_eventlog}
\title{Metric: Activity Presence}
\usage{
activity_presence(eventlog, append, append_column, sort, ...)

\method{activity_presence}{eventlog}(eventlog, append = F,
  append_column = "absolute", sort = TRUE, ...)

\method{activity_presence}{grouped_eventlog}(eventlog, append = F,
  append_column = "absolute", sort = TRUE, ...)
}
\arguments{
\item{eventlog}{The dataset to be used. Should be a (grouped) eventlog object.
\code{eventlog}.}

\item{append}{Logical, indicating whether to append results to original event log. Ignored when level is log or trace.}

\item{append_column}{Which of the output columns to append to log, if append = T. Default column depends on chosen level.}

\item{sort}{Sort output on count. Defaults to TRUE. Only for levels with frequency count output.}

\item{...}{Deprecated arguments}
}
\description{
Calculates for each activity type in what percentage of cases it is present.
}
\details{
An indication of variance can be the presence of the activities in the different cases. This metric shows for each activity the absolute
number of cases in which each activity occurs together with its relative presence.
}
\section{Methods (by class)}{
\itemize{
\item \code{eventlog}: Compute activity presence for event log

\item \code{grouped_eventlog}: Compute activity presence for grouped eventlog
}}

\examples{
\dontrun{
data <- data.frame(case = rep("A",5),
activity_id = c("A","B","C","D","E"),
activity_instance_id = 1:5,
lifecycle_id = rep("complete",5),
timestamp = 1:5,
resource = rep("resource 1", 5))

log <- bupaR::eventlog(data,case_id = "case",
activity_id = "activity_id",
activity_instance_id = "activity_instance_id",
lifecycle_id = "lifecycle_id",
timestamp = "timestamp",
resource_id = "resource")

activity_presence(log)
}

}
\references{
Swennen, M. (2018). Using Event Log Knowledge to Support Operational Exellence Techniques (Doctoral dissertation). Hasselt University.
}
