
end_activities_resource_activity <- function(eventlog) {

	stop_eventlog(eventlog)

	resource_classifier <- resource_id(eventlog)
	case_classifier <- case_id(eventlog)
	event_classifier <- activity_id(eventlog)
	colnames(eventlog)[colnames(eventlog) == timestamp(eventlog)] <- "timestamp_classifier"

	e <- eventlog %>%
		group_by_(case_classifier) %>%
		mutate(rank = row_number(timestamp_classifier),
			   max_rank = max(rank)) %>%
		filter(rank == max_rank) %>% ungroup()

	ncases <- n_cases(eventlog)

	r <- e %>%
		group_by_(resource_classifier, event_classifier) %>%
		summarize(absolute = n()) %>%
		ungroup() %>%
		arrange(desc(absolute))
	r$relative <- r$absolute/ncases
	r$cum_sum <- cumsum(r$relative)
	return(r)

}
