% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare}
\alias{compare}
\title{Compare ED50 Estimation of Independent Two-sample Case}
\usage{
compare(group1, group2, alpha = 0.05)
}
\arguments{
\item{group1}{A list object of ED50 estimation.}

\item{group2}{Another list object of ED50 estimation to be compared with.}

\item{alpha}{The significant level of test. 0.05 is the defaut value.}
}
\value{
The difference between two groups of ED50 estimation in terms of statistical
significance.
}
\description{
Test the statistical  difference of two independent estimation results of ED50.
}
\examples{
library(ed50)
ans1 <- estimate(groupS$doseSequence, groupS$responseSequence, method = 'ModTurPoint')
ans2 <- estimate(groupSN$doseSequence, groupSN$responseSequence, method = 'Dixon-Mood')
compare(ans1, ans2)
}
\references{
Noguchi, K., & Marmolejo-Ramos, F. (2016). Assessing equality of means using the
overlap of range-preserving confidence intervals. American Statistician, 70(4), 325-334.
}
