% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.recombinator.sbx.R
\name{setupSBXRecombinator}
\alias{setupSBXRecombinator}
\title{Generator of the Simulated Binary Crossover (SBX) recombinator.}
\usage{
setupSBXRecombinator(eta = 5, p = 1)
}
\arguments{
\item{eta}{[\code{numeric(1)}]\cr
Parameter eta, i.e., the distance parameters of the crossover distribution.}

\item{p}{[\code{numeric(1)}]\cr
Crossover probability for each gene. Default is \code{1.0}.}
}
\value{
[\code{ecr_recombinator}]
}
\description{
The Simulated Binary Crossover was first proposed by [1]. It i suited for
float representation only and creates two offspring. Given parents \eqn{p_1, p_2}
the offspring are generated as \eqn{c_{1/2} = \bar{x} \pm \frac{1}{2}\beta(p_2 - p_1)}
where \eqn{\bar{x} = \frac{1}{2}(p_1 + p_2), p_2 > p_1}. This way \eqn{\bar{c} = \bar{x}}
is assured.
}
\note{
This is the default recombination operator used in the NSGA-II EMOA (see \code{\link{nsga2}}).
}
\references{
[1] Deb, K. and Agrawal, R. B. (1995). Simulated binary crossover for continuous
search space. Complex Systems 9(2), 115-148.
}
\seealso{
Other recombinators: \code{\link{setupCrossoverRecombinator}},
  \code{\link{setupIntermediateRecombinator}},
  \code{\link{setupNullRecombinator}},
  \code{\link{setupOXRecombinator}},
  \code{\link{setupPMXRecombinator}}
}

