% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.nsga2.R
\name{nsga2}
\alias{nsga2}
\title{Implementation of the NSGA-II EMOA algorithm by Deb.}
\usage{
nsga2(task, n.population = 100L, n.offspring = n.population,
  parent.selector = setupSimpleSelector(), mutator = setupGaussMutator(),
  recombinator = setupCrossoverRecombinator(), max.iter = 100L,
  max.evals = NULL, max.time = NULL, ...)
}
\arguments{
\item{task}{[\code{ecr_optimization_task}]\cr
Optimization task. If a \code{smoof_function} is passed it is automatically
converted into a task.}

\item{n.population}{[\code{integer(1)}]\cr
Population size. Default is \code{100}.}

\item{n.offspring}{[\code{integer(1)}]\cr
Offspring size, i.e., number of individuals generated by variation operators
in each iteration. Default is \code{n.population}.}

\item{parent.selector}{[\code{ecr_selector}]\cr
Selection operator which implements a procedure to copy individuals from a
given population to the mating pool, i. e., allow them to become parents.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{max.iter}{[\code{integer(1)}]\cr
Maximal number of iterations. Default ist \code{100L}.}

\item{max.evals}{[\code{integer(1)}]\cr
Maximal number of iterations/generations. Default is \code{Inf}.}

\item{max.time}{[\code{integer(1)}]\cr
Time budget in seconds. Default ist \code{Inf}.}

\item{...}{[any]\cr
Further arguments passed to \code{\link{setupECRControl}}.}
}
\value{
[\code{ecr_nsga2_result, ecr_multi_objective_result}]
}
\description{
The NSGA-II merges the current population and the generated offspring and
reduces it by means of the following procedure: It first applies the non
dominated sorting algorithm to obtain the nondominated fronts. Starting with
the first front, it fills the new population until the i-th front does not fit.
It then applies the secondary crowding distance criterion to select the missing
individuals from the i-th front.
}
\note{
This is a pure R implementation of the NSGA-II algorithm. It hides the regular
\pkg{ecr} interface and offers a more R like interface while still being quite
adaptable.
}
\references{
Deb, K., Pratap, A., and Agarwal, S. A Fast and Elitist Multiobjective Genetic
Algorithm: NSGA-II. IEEE Transactions on Evolutionary Computation, 6 (8) (2002),
182-197.
}
\keyword{optimize}

