% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_div.r
\name{faith}
\alias{faith}
\title{Faith's PD}
\usage{
faith(counts, tree = NULL, cpus = n_cpus())
}
\arguments{
\item{counts}{An OTU abundance matrix where each column is a sample, and
each row is an OTU. Any object coercible with \code{as.matrix()} can be
given here, as well as \code{phyloseq}, \code{rbiom}, \code{SummarizedExperiment},
and \code{TreeSummarizedExperiment} objects.}

\item{tree}{A \code{phylo}-class object representing the phylogenetic tree for
the OTUs in \code{counts}. The OTU identifiers given by \code{colnames(counts)}
must be present in \code{tree}. Can be omitted if a tree is embedded with
the \code{counts} object or as \code{attr(counts, 'tree')}.}

\item{cpus}{How many parallel processing threads should be used. The
default, \code{n_cpus()}, will use all logical CPU cores.}
}
\value{
A numeric vector.
}
\description{
Faith's phylogenetic diversity metric.\cr\cr
A higher value indicates a greater amount of evolutionary history
represented within the community, suggesting higher biodiversity in terms of
evolutionary relationships.
}
\section{Calculation}{


Given \eqn{n} branches with lengths \eqn{L} and a sample's
abundances on each of those branches coded as 1 for present or 0 for absent:

\deqn{\sum_{i = 1}^{n} P_i \times L_i}
}

\examples{
    # Example counts matrix
    ex_counts
    
    # Faith diversity values
    faith(ex_counts, tree = ex_tree)
    
}
\references{
Faith DP 1992.
Conservation evaluation and phylogenetic diversity.
Biological Conservation, 61:1-10.
\doi{10.1016/0006-3207(92)91201-3}
}
\seealso{
Other alpha_diversity: 
\code{\link{chao1}()},
\code{\link{inv_simpson}()},
\code{\link{shannon}()},
\code{\link{simpson}()}
}
\concept{alpha_diversity}
