% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_estimates_MU}
\alias{ec_estimates_MU}
\title{Obtain upper level model estimates}
\usage{
ec_estimates_MU(est, quantiles = c(0.05, 0.95))
}
\arguments{
\item{est}{is an 'echoice2' draw object (list)}

\item{quantiles}{quantile for CI}
}
\value{
tibble with MU (upper level) summaries
}
\description{
Obtain upper level model estimates
}
\examples{
data(icecream)
#run MCMC sampler (use way more than 20 draws for actual use)
icecream_est <- icecream \%>\% dplyr::filter(id<20) \%>\% vd_est_vdm(R=20, cores=2)
#Upper-level summary
icecream_est \%>\% ec_estimates_MU
}
