% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.theme}
\alias{ec.theme}
\title{Themes}
\usage{
ec.theme(wt, name = "custom", code = NULL)
}
\arguments{
\item{wt}{Required \code{echarty} widget as returned by \link{ec.init}}

\item{name}{Name of existing theme file (without extension), or name of custom theme defined in \code{code}.}

\item{code}{Custom theme as JSON formatted string, default NULL.}
}
\value{
An \code{echarty} widget.
}
\description{
Apply a pre-built or custom coded theme to a chart
}
\details{
Just a few built-in themes are included in folder \code{inst/themes}.\cr
Their names are dark, gray, jazz, dark-mushroom and macarons.\cr
The entire ECharts theme collection could be found \href{https://github.com/apache/echarts/tree/master/theme}{here} and files copied if needed.\cr
To create custom themes or view predefined ones, visit \href{https://echarts.apache.org/en/theme-builder.html}{this site}.
}
\examples{
mtcars |> ec.init() |> ec.theme('dark-mushroom')
cars |> ec.init() |> ec.theme('mine', code=
  '{"color": ["green","#eeaa33"], 
    "backgroundColor": "lemonchiffon"}')

}
