% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.fromJson}
\alias{ec.fromJson}
\title{JSON to chart}
\usage{
ec.fromJson(txt, ...)
}
\arguments{
\item{txt}{Could be one of the following:\cr
\verb{   }class \emph{url}, like \code{url('https://serv.us/cars.txt')}\cr
\verb{   }class \emph{file}, like \code{file('c:/temp/cars.txt','rb')}\cr
\verb{   }class \emph{json}, like \code{ec.inspect(p)}, for options or full\cr
\verb{   }class \emph{character}, JSON string with options only, see example below\cr}

\item{...}{Any attributes to pass to internal \link{ec.init} when \emph{txt} is options only}
}
\value{
An \emph{echarty} widget.
}
\description{
Convert JSON string or file to chart
}
\details{
\emph{txt} could be either a list of options (x$opts) to be set by \href{https://echarts.apache.org/en/api.html#echartsInstance.setOption}{setOption},\cr
OR an entire \emph{htmlwidget} generated thru \link{ec.inspect} with \emph{target='full'}.\cr
The latter imports all JavaScript functions defined by the user.
}
\examples{
txt <- '{
   "xAxis": { "data": ["Mon", "Tue", "Wed"]}, "yAxis": { },
   "series": { "type": "line", "data": [150, 230, 224] } }'
ec.fromJson(txt)  # text json
# outFile <- 'c:/temp/cars.json'
# cars |> ec.init() |> ec.inspect(target='full', file=outFile)
# ec.fromJson(file(outFile, 'rb'))
# ec.fromJson(url('http://localhost/echarty/cars.json'))
ec.fromJson('https://helgasoft.github.io/echarty/test/pfull.json')
}
