% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.fromJson}
\alias{ec.fromJson}
\title{JSON to chart}
\usage{
ec.fromJson(txt, ...)
}
\arguments{
\item{txt}{JSON character string, url, or file, see \link[jsonlite]{fromJSON}}

\item{...}{Any arguments to pass to internal \link{ec.init}}
}
\value{
An \code{echarty} widget.
}
\description{
Convert JSON string to chart
}
\details{
\code{txt} should contain the full list of options required to build a chart.
It is subsequently passed to ECharts function \href{https://echarts.apache.org/en/api.html#echartsInstance.setOption}{setOption}.
}
\examples{
txt <- '{
  "xAxis": { "type": "category",
     "data": ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"]
   },
   "yAxis": { "type": "value" },
   "series": { "type": "line",
     "data": [150, 230, 224, 218, 135, 147, 260]
   } }'
ec.fromJson(txt)

}
