% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ec.init}
\alias{ec.init}
\title{Initialize}
\usage{
ec.init(
  df = NULL,
  load = NULL,
  width = NULL,
  height = NULL,
  elementId = NULL,
  renderer = "canvas",
  preset = TRUE,
  group1 = TRUE,
  js = NULL,
  ...
)
}
\arguments{
\item{df}{A data.frame to be used as dataset in the chart, default NULL}

\item{load}{Name(s) of plugin(s) to load. Currently supported are
\emph{3D, GL, leaflet, custom}. Could be a vector or comma-delimited string. default NULL.}

\item{width, height}{A valid CSS unit (like \code{'100\%'},
\code{'500px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{elementId}{Id of the widget, default NULL}

\item{renderer}{\code{'canvas'} (default) or \code{'svg'}.}

\item{preset}{Enable (TRUE, default) or disable(FALSE) presets like xAxis,yAxis,dataset,series, but not \code{group1}.}

\item{group1}{Preset parameters if df is grouped, default TRUE \cr
If the grouping is on multiple columns, only the first one is used.}

\item{js}{A Javascript expression to evaluate, default NULL.}

\item{...}{Any other arguments to pass to the widget.}
}
\value{
A widget to plot, or to save and expand with more features.
}
\description{
Initialize a chart.
}
\details{
Widgets are defined in \href{https://www.htmlwidgets.org/develop_intro.html}{htmlwidgets}.
This command creates one with \code{\link[htmlwidgets]{createWidget}}, then adds some EchartsJS features to it.\cr
It also presets values for xAxis,yAxis,dataset and series. The user can overwrite them if needed.
}
\examples{
 # basic scatter chart from a data.frame, using presets
 cars \%>\% ec.init()
 
}
