% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-solve-method.R
\name{ecld.solve}
\alias{ecld.laplace_B}
\alias{ecld.solve}
\alias{ecld.solve_by_poly}
\alias{ecld.solve_isomorphic}
\alias{ecld.solve_quartic}
\title{Analytic solution for \eqn{y(x)} in lambda distribution}
\usage{
ecld.solve(a, b, ...)

ecld.laplace_B(beta, sgn = 0, sigma = 0)

ecld.solve_quartic(a, b, ...)

ecld.solve_by_poly(a, b, ...)

ecld.solve_isomorphic(a, b, ...)
}
\arguments{
\item{a}{an object of ecld class}

\item{b}{a vector of \eqn{x} values}

\item{...}{Not used. Only here to match the generic signature.}

\item{beta}{the skew parameter}

\item{sgn}{sign of \eqn{-1, 0, +1}}

\item{sigma}{the scale parameter, optional}
}
\value{
A vector for \eqn{y(x)}
}
\description{
Analytic solution for \eqn{y(x)} if available. 
\eqn{ecld.laplace_B} is a utility function for the slopes of 
a skew Laplace distribution at lambda=2: \eqn{B^+} and \eqn{B^-} 
with \eqn{B^0/2=B^{+}+B^{-}}. If \code{sigma} is provided, B notation
is expanded for IMGF where \eqn{B^{+}_{\sigma} B^{-}_{\sigma} = \exp(\mu_D)}.
SGED is supported.
}
\examples{
ld <- ecld(sigma=0.01*ecd.mp1)
x <- seq(-0.1, 0.1, by=0.01)
ecld.solve(ld,x)
}
\author{
Stephen H. Lihn
}
\keyword{solve}

