% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_val.R
\name{ind_val}
\alias{ind_val}
\title{Helper function for Indicator Species Analysis}
\usage{
ind_val(
  df,
  stand = NULL,
  species = NULL,
  abundance = NULL,
  group = NULL,
  row_data = FALSE
)
}
\arguments{
\item{df}{A data.frame, which has three cols: stand, species, abundance.
Community matrix should be converted using table2df().}

\item{stand, species, abundance}{A text to specify each column.
If NULL, 1st, 2nd, 3rd column will be used.}

\item{group}{A text to specify group column.}

\item{row_data}{A logical.
TRUE: return row result data of labdsv::indval().}
}
\value{
A data.frame.
}
\description{
Calculating diversity indices such as species richness (s),
Shannon's H' (h), Simpson' D (d), Simpson's inverse D (i).
}
\examples{
\donttest{
library(dplyr)
library(tibble)
data(dune, package = "vegan")
data(dune.env, package = "vegan")
df <- 
  dune \%>\%
  table2df(st = "stand", sp = "species", ab = "cover") \%>\%
  dplyr::left_join(tibble::rownames_to_column(dune.env, "stand"))
ind_val(df, abundance = "cover", group = "Moisture")
}

}
