% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_read_shp.R
\name{ebv_read_shp}
\alias{ebv_read_shp}
\title{Read subset (shapefile) of one datacube of an EBV netCDF}
\usage{
ebv_read_shp(
  filepath,
  datacubepath,
  entity = NULL,
  timestep = 1,
  shp,
  outputpath = NULL,
  touches = TRUE,
  overwrite = FALSE,
  ignore_RAM = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{datacubepath}{Character. Path to the datacube (use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}).}

\item{entity}{Character or Integer. Default is NULL. If the structure is 3D,
the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs.}

\item{timestep}{Integer. Choose one or several timesteps (vector).}

\item{shp}{Character. Path to the shapefile defining the subset. Ending needs
to be *.shp.}

\item{outputpath}{Character. Default: NULL, returns the data as a raster
object in memory. Optional: set path to write subset as GeoTiff on disk.}

\item{touches}{Logical. Default: TRUE, all pixels touched by the polygon(s) will
be updated. Set to FALSE to only include pixels that are on the line render
path or have center points inside the polygon(s).}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE to overwrite the
outputfile defined by 'outputpath'.}

\item{ignore_RAM}{Logical. Default: FALSE. Checks if there is enough space in
your memory to read the data. Can be switched off (set to TRUE).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Returns a raster object if no outputpath is given. Otherwise the
subset is written onto the disk and the ouputpath is returned.
}
\description{
Read a subset of one or more layers from one datacube of the
netCDF file. Subset definition by a shapefile.
}
\examples{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

#set path to shp file - cameroon country borders
shp_path <- system.file(file.path("extdata","cameroon.shp"), package="ebvcube")

\donttest{
#read subset - return Raster
cSAR_cameroon <- ebv_read_shp(filepath = file, datacubepath = datacubes[1,1],
                             entity = 1, timestep = 1, shp = shp_path,
                             outputpath = NULL, ignore_RAM = TRUE)
}
}
\seealso{
\code{\link[=ebv_read_bb]{ebv_read_bb()}} for subsetting via bounding box.
}
