% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_summary}
\alias{load_summary}
\title{Stixel summary file loader}
\usage{
load_summary(path, return_sf = FALSE)
}
\arguments{
\item{path}{character; full path to the directory containing single species
eBird Status and Trends products.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
data.frame containing stixel summary information about each stixel
centroid.
}
\description{
Internal function used by \code{\link[=load_pis]{load_pis()}} to get the stixel summary information
(from summary.txt).
}
\examples{
\donttest{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# stixel summaries
summaries <- ebirdst:::load_summary(sp_path)
dplyr::glimpse(summaries)
}
}
\keyword{internal}
