% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneVariable.R
\name{cloneVariable}
\alias{cloneVariable}
\title{Clone a variable.}
\usage{
cloneVariable(
  GADSdat,
  varName,
  new_varName,
  label_suffix = "",
  checkVarName = TRUE
)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Name of the variable to be cloned.}

\item{new_varName}{Name of the new variable.}

\item{label_suffix}{Suffix added to variable label for the newly created variable in the \code{GADSdat}.}

\item{checkVarName}{Logical. Should \code{new_varName} be checked by \code{\link{checkVarNames}}?}
}
\value{
Returns a \code{GADSdat}.
}
\description{
Clone a variable as part of a \code{GADSdat} object.
}
\details{
The variable is simply duplicated and assigned a new name.
}
\examples{
# duplicate the variable schtype
pisa_new <- cloneVariable(pisa, varName = "schtype", new_varName = "schtype_new")

}
