% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recodeGADS.R
\name{recodeGADS}
\alias{recodeGADS}
\title{Recode a labeled variable.}
\usage{
recodeGADS(
  GADSdat,
  varName,
  oldValues,
  newValues,
  existingMeta = c("stop", "value", "value_new")
)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Name of the variable to be recoded.}

\item{oldValues}{Vector containing the old values.}

\item{newValues}{Vector containing the new values (in the respective order as \code{oldValues}).}

\item{existingMeta}{If values are recoded, which meta data should be used (see details)?}
}
\value{
Returns a \code{GADSdat}.
}
\description{
Recode a labeled variable as part of a \code{GADSdat} or \code{all_GADSdat} object.
}
\details{
Applied to a \code{GADSdat} or \code{all_GADSdat} object, this function is a wrapper of \code{\link{getChangeMeta}}
and \code{\link{applyChangeMeta}}.
\code{oldValues} and \code{newValues} are matched by ordering in the function call.

If changes are performed on value levels, recoding into
existing values can occur. In these cases, \code{existingMeta} determines how the resulting meta data conflicts are handled,
either raising an error if any occur (\code{"stop"}), keeping the original meta data for the value (\code{"value"}) or using the meta
data in the \code{changeTable} or, if incomplete, from the recoded value (\code{"value_new"}).

Missing values (\code{NA}) are supported in \code{oldValues} but not in \code{newValues}. For recoding values to
\code{NA} see \code{\link{recode2NA}} instead.
For recoding character variables, using lookup tables via \code{\link{createLookup}} is recommended. For changing
value labels see \code{\link{changeValLabels}}.
}
\examples{
# Example gads
example_df <- data.frame(ID = 1:5, color = c("blue", "blue", "green", "other", "other"),
                        animal = c("dog", "Dog", "cat", "hors", "horse"),
                        age = c(NA, 16, 15, 23, 50),
                        stringsAsFactors = FALSE)
example_df$animal <- as.factor(example_df$animal)
gads <- import_DF(example_df)

# simple recode
gads2 <- recodeGADS(gads, varName = "animal",
                   oldValues = c(3, 4), newValues = c(7, 8))


}
