% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkVarNames.R
\name{checkVarNames}
\alias{checkVarNames}
\title{Check names for \code{SQLite} conventions.}
\usage{
checkVarNames(GADSdat)
}
\arguments{
\item{GADSdat}{\code{GADSdat} or \code{all_GADSdat} object imported via eatGADS.}
}
\value{
Returns the original object with updated variable names.
}
\description{
Applies variable names changes to \code{GADSdat} or \code{all_GADSdat} objects.
}
\details{
Illegal names in a \code{SQLite} data base include \code{SQLite} keywords (see \code{\link[eatDB]{sqlite_keywords}}) and names
with a \code{"."} in it.
}
\examples{
# Change example data set (create an invalid variable name)
pisa2 <- changeVarNames(pisa, oldNames = "computer_age",
                        newNames = "computer.age")

pisa3 <- checkVarNames(pisa2)

}
