% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_DB_infos.R
\name{dbSingleDF}
\alias{dbSingleDF}
\title{Extract a single data table from a relational data base.}
\usage{
dbSingleDF(dfName = "Meta_Data", filePath)
}
\arguments{
\item{dfName}{Name of the data table which should be extracted.}

\item{filePath}{Path of the existing db file.}
}
\value{
Returns a data frame with all variables and cases as in the corresponding data table.
}
\description{
Function to extract a single, complete data table from a relational data base. Especially useful for the extraction of the meta information stored in \code{Meta_Data}.
}
\details{
This function makes use of the \code{DBI::dbReadTable} function and extracts a complete data table from a data base. All variables are extracted and all rows are used. For extracting only some variables or merging data tables see \code{\link{dbPull}}.
}
\examples{
db_path <- system.file("extdata", "example_dataBase.db", package = "eatDB")

## Extract all meta information
meta_data <- dbSingleDF(dfName = "Meta_Data", filePath = db_path)
meta_data

## Extract a specific data table
NoImp <- dbSingleDF(dfName = "NoImp", filePath = db_path)
NoImp

}
