% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankingRFEAT.R
\name{rankingRFEAT}
\alias{rankingRFEAT}
\title{Ranking of variables by Random Forest + Efficiency Analysis Trees.}
\usage{
rankingRFEAT(object, barplot = TRUE, digits = 2)
}
\arguments{
\item{object}{A RFEAT object.}

\item{barplot}{Logical. If \code{TRUE}, a barplot with importance scores is displayed.}

\item{digits}{Integer. Decimal units.}
}
\value{
Dataframe with the importance scores. If \code{barplot = TRUE}, it is returned a list containing the scores and the barplot.
}
\description{
This function calculates variable importance through a Random Forest + Efficiency Analysis Trees model.
}
\examples{
\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
RFEAT_model <- RFEAT(data = simulated, x = c(1,2), y = c(3, 4))

rankingRFEAT(object = RFEAT_model,
             barplot = TRUE,
             digits = 2)
}

}
