% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sc.R
\name{check_marker}
\alias{check_marker}
\title{Verify and Explore Cell Type Annotations}
\usage{
check_marker(marker, cl = c(), topcellN = 2, cis = FALSE)
}
\arguments{
\item{marker}{A \code{data.table} object, which is the result of a call to \code{matchCellMarker2()}.
This object must contain the attributes set by \code{matchCellMarker2} for the function to work correctly.}

\item{cl}{A numeric or character vector specifying the cluster IDs to be inspected.}

\item{topcellN}{An integer. For each cluster in \code{cl}, the function will retrieve
markers for the top \code{topcellN} cell type annotations. Defaults to 2.}

\item{cis}{A logical value that switches the function's mode. See Details.
Defaults to \code{FALSE}.}
}
\value{
A named list. Each name in the list is a cell type, and each element
is a character vector of its corresponding marker genes.
}
\description{
A post-analysis function that helps to verify and explore the automated cell
type annotations generated by \code{matchCellMarker2}. It retrieves marker genes
for the top-matching cell types of specified clusters, allowing for deeper
inspection of the annotation results.
}
\details{
The function provides two distinct modes for marker retrieval, controlled by
the \code{cis} parameter. This allows the user to answer two different, important
questions:
\itemize{
\item \strong{\code{cis = FALSE} (Default): "Is the annotation correct?"}
This mode answers the question by fetching the \emph{canonical} markers for the
annotated cell type from the reference database (via \code{get_marker}). It automatically
uses the same filtering criteria (species, tissue, etc.) that were used in the
original \code{matchCellMarker2} call, ensuring consistency.
\item \strong{\code{cis = TRUE}: "Why was this annotation made?"}
This mode answers the question by extracting the \emph{local} markers from the
user's own data (i.e., the differentially expressed genes from the \code{marker}
input) that led to the annotation. This helps understand the evidence
behind the match.
}
}
\examples{
\dontrun{
library(easybio)
data(pbmc.markers)

# Step 1: Generate cell type annotations
matched_cells <- matchCellMarker2(pbmc.markers, n = 50, spc = "Human")

# Step 2: Verify the annotation for cluster 0.
# Let's check the top annotation (topcellN = 1).

# Question 1: "Is cluster 0 really a CD4-positive T cell?
# Let's see the canonical markers for it."
# Note: We don't need to pass 'spc' here; it's retrieved from matched_cells.
reference_markers <- check_marker(matched_cells, cl = 0, topcellN = 1)
print(reference_markers)
# Now you would typically use these markers in Seurat::DotPlot() or Seurat::FeaturePlot()

# Question 2: "Which of my genes made the algorithm think cluster 0
# is a CD4-positive T cell?"
local_markers <- check_marker(matched_cells, cl = 0, topcellN = 1, cis = TRUE)
print(local_markers)
}
}
\seealso{
\code{\link{matchCellMarker2}} to generate the input for this function.
\code{\link{get_marker}} which is used internally when \code{cis = FALSE}.
\code{\link{plotSeuratDot}} to visualize the results.
}
