% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EnsCorr.R
\name{EnsCorr}
\alias{EnsCorr}
\title{Correlation with Ensemble Mean}
\usage{
EnsCorr(ens, obs)
}
\arguments{
\item{ens}{n x k matrix of n forecasts from k ensemble members}

\item{obs}{n verifying observations}
}
\description{
Computes the ensemble mean correlation (Pearson) with the verifying
observations.
}
\examples{
tm <- toymodel()

## compute correlation directly
EnsCorr(tm$fcst, tm$obs)

## compute correlation using veriApply
veriApply("EnsCorr", tm$fcst, tm$obs)

}
\seealso{
\code{\link{veriApply}}
}
