% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_info_theory.R
\name{variable_entropy}
\alias{variable_entropy}
\title{Calculate Entropy of Each Variable in Data Frame}
\usage{
variable_entropy(data, unit = "bits")
}
\arguments{
\item{data}{Data Frame to compute on}

\item{unit}{Unit to measure entropy. Either "bits" (default) or "nats".}
}
\value{
Named numeric vector containing entropy values
}
\description{
Calculates Shannon entropy of all variables in a data frame in bits (default) or
natural units. Missing values are omitted from the calculation.
}
\examples{
a <- matrix(c(c(1,1,1,1,1,1, 1,2,3,4,5,6)),ncol = 2, dimnames =
list(seq(1,6), c("no_entropy","entropy")))
variable_entropy(as.data.frame(a))
}
\references{
Shannon, C. E. A mathematical theory of communication. The Bell
  System Technical Journal 27, 379–423 (1948).
}
