% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{encode_bin_cat_vec}
\alias{encode_bin_cat_vec}
\title{Encode a categorical vector with binary categories}
\usage{
encode_bin_cat_vec(x, values = NULL, numeric_out = FALSE)
}
\arguments{
\item{x}{non-numeric input vector}

\item{values}{Optional named vector of user-defined values for binary values
using \code{binary_label_1 = binary_label_2} syntax (e.g. \code{c("No" =
"Yes")} would assign level 1 to "No" and 2 to "Yes").}

\item{numeric_out}{If true, numeric vector is returned. If false, factor is
returned.}
}
\value{
Factor with false finding encoded as 1 and true finding encoded as
  2. Alternatively, numeric vector if \code{numeric_out} parameter is
  \code{TRUE}.
}
\description{
In a character vector, converts binary categories to factor levels.
}
\details{
Binary categories to convert can be specified with a named character vector,
specified in \code{values}. The syntax of the named vector is:
\code{negative_finding = positive_finding}.  If \code{values} is not
provided, the default list will be used: \code{"No"="Yes", "No/unknown" =
"Yes", "no/unknown" = "Yes", "Non-user" = "User", "Never" = "Ever", "WT" =
"MT"}.
}
