% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{scale_minmax}
\alias{scale_minmax}
\title{Calculate and apply a minmax scale}
\usage{
scale_minmax(x)
}
\arguments{
\item{x}{A numeric vector, matrix or data frame.}
}
\value{
The centered, scaled matrix or vector. The numeric centering and scalings used are returned as attributes.
}
\description{
Calculate and apply a minmax scale
}
\examples{
## Generate a matrix from a normal distribution
## with a large standard deviation, centered at c(5, 5)
x <- matrix(rnorm(200*2, sd = 10, mean = 5), ncol = 2)

## Minmax scale the data
x_scaled <- scale_minmax(x)

## Plot rescaled data
plot(x_scaled)

## Show ranges of each column
apply(x_scaled, 2, range)
}
