% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrCook.R
\name{dynr.cook}
\alias{dynr.cook}
\title{Cook a dynr model to estimate its free parameters}
\usage{
dynr.cook(dynrModel, conf.level = 0.95, infile, verbose = TRUE,
  weight_flag = FALSE, debug_flag = FALSE)
}
\arguments{
\item{dynrModel}{a dynr model compiled using dynr.model, consisting of recipes for submodels, 
starting values, parameter names, and C code for each submodel}

\item{conf.level}{a cumulative proportion indicating the level of desired confidence intervals for
the final parameter estimates (default is .95)}

\item{infile}{(not required for models specified through the recipe functions) the name of a file 
that has the C codes for all dynr submodels for those interested in specifying a model directly in C}

\item{verbose}{a flag (TRUE/FALSE) indicating whether more detailed intermediate output during the 
estimation process should be printed}

\item{weight_flag}{a flag (TRUE/FALSE) indicating whether the negative log likelihood function should 
be weighted by the length of the time series for each individual}

\item{debug_flag}{a flag (TRUE/FALSE) indicating whether users want additional dynr output that can 
be used for diagnostic purposes}
}
\description{
Cook a dynr model to estimate its free parameters
}
\details{
Free parameter estimation uses the SLSQP routine from NLOPT.

The typical items returned in the cooked model are the smoothed latent variable estimates only.  The time-varying latent variable means are called \code{eta_smooth_final}; the time-varying latent variable (co-)variances are called \code{error_cov_smooth_final}; and the time-varying smoothed probability of each regime is called \code{pr_t_given_T}.

When \code{debug_flag} is TRUE, then additional information is passed into the cooked model. This information can get quite large, so it is not returned unless requested. The information gets large because these items often depend on the regime in addition to time. The updated latent states for each possible regime are in \code{eta_regime_t}; the updated latent covariances for each possible regime are in \code{error_cov_regime_t}; the latent residual (innovation vector) from each regime to each regime is stored in \code{innov_vec}; and the inverse of the updated latent covariance matrix from each regime to each regime is in \code{inverse_residual_cov}.
}
\examples{
#fitted.model <- dynr.cook(model)
}

