% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrPlot.R
\name{dynr.ggplot}
\alias{autoplot.dynrCook}
\alias{dynr.ggplot}
\title{The ggplot of the smoothed state estimates and the most likely regimes}
\usage{
dynr.ggplot(res, dynrModel, style = 1, numSubjDemo = 2, idtoPlot = c(),
  names.state, names.observed, names.regime, shape.values, title, ylab,
  is.bw = FALSE, colorPalette = "Set2", fillPalette = "Set2",
  mancolorPalette, manfillPalette, ...)

\method{autoplot}{dynrCook}(object, dynrModel, style = 1, numSubjDemo = 2,
  idtoPlot = c(), names.state, names.observed, names.regime, shape.values,
  title, ylab, is.bw = FALSE, colorPalette = "Set2", fillPalette = "Set2",
  mancolorPalette, manfillPalette, ...)
}
\arguments{
\item{res}{The dynr object returned by \code{dynr.cook()}.}

\item{dynrModel}{The model object to plot.}

\item{style}{The style of the plot. If style is 1 (default), user-selected smoothed state variables are plotted. If style is 2, user-selected observed-versus-predicted values are plotted.}

\item{numSubjDemo}{The number of subjects to be randomly selected for plotting.}

\item{idtoPlot}{Values of the ID variable to plot.}

\item{names.state}{(optional) The names of the states to be plotted, which should be a subset of the state.names slot of the measurement slot of dynrModel.}

\item{names.observed}{(optional) The names of the observed variables to be plotted, which should be a subset of the obs.names slot of the measurement slot of dynrModel.}

\item{names.regime}{(optional) The names of the regimes to be plotted, which can be missing.}

\item{shape.values}{(optional) A vector of values that correspond to the shapes of the points, which can be missing. See the R documentation on pch for details on possible shapes.}

\item{title}{(optional) A title of the plot.}

\item{ylab}{(optional) The label of the y axis.}

\item{is.bw}{Is plot in black and white? The default is FALSE.}

\item{colorPalette}{A color palette for lines and dots. It is a value passed to the palette argument of the \code{ggplot2::scale_colour_brewer()} function. These palettes are in the R package \pkg{RColorBrewer}. One can find them by attaching the package with \code{library(RColorBrewer)} and run \code{display.brewer.all()}.}

\item{fillPalette}{A color palette for blocks. It is a value passed to the palette argument of the \code{ggplot2::scale_fill_brewer()} function. These palettes are in the package \pkg{RColorBrewer}. One can find them by attaching the package with \code{library(RColorBrewer)} and run \code{display.brewer.all()}.}

\item{mancolorPalette}{(optional) A color palette for manually scaling the colors of lines and dots. It is a vector passed to the values argument of the \code{ggplot2::scale_colour_manual} function.}

\item{manfillPalette}{(optional) A color palette for manually scaling the colors of filled blocks. It is a vector passed to the values argument of the \code{ggplot2::scale_fill_manual} function.}

\item{...}{A list of elements that modify the existing ggplot theme. Consult the \code{ggplot2::theme()} function in the R package \pkg{ggplot2} for more options.}

\item{object}{The same as res. The dynr object returned by dynr.cook().}
}
\value{
ggplot object

ggplot object
}
\description{
The ggplot of the smoothed state estimates and the most likely regimes
}
\details{
This function outputs a ggplot layer that can be modified using functions in the package \pkg{ggplot2}. That is, one can add layers, scales, coords and facets with the "+" sign. In an example below, the \code{ggplot2::ylim()} function is used to modify the limits of the y axis of the graph. More details can be found on \url{https://ggplot2.tidyverse.org/} and \url{https://ggplot2.tidyverse.org/reference/}.

The two functions \code{dynr.ggplot()} and \code{autoplot()} as identical aliases of one another.  The \code{autoplot()} function is an S3 method from the package \pkg{ggplot2} that allows many objects to be plotted and works like the base \code{plot()} function.
}
\examples{
# The following code is part of a demo example in dynr
\donttest{
demo(RSLinearDiscreteYang, package='dynr')
p <- dynr.ggplot(yum, dynrModel = rsmod, style = 1,
 	names.regime = c("Deactivated", "Activated"),
 	title = "(B) Results from RS-AR model", numSubjDemo = 1,
 	shape.values = c(1),
 	text = element_text(size = 16),
 	is.bw = TRUE)
# One can modify the limits on the y axis by using '+'
p + ggplot2::ylim(-2, 4)

autoplot(yum, dynrModel = rsmod, style = 1,
	names.regime = c("Deactivated", "Activated"),
	title = "(B) Results from RS-AR model", numSubjDemo = 1,
	shape.values = c(1),
	text = element_text(size = 16),
	is.bw = TRUE)
}
}

