% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_design_matrix.R
\name{ddFixed}
\alias{ddFixed}
\alias{ddFixed_intercept}
\title{Auxiliary Functions for Fixed Effects}
\usage{
ddFixed(object)

ddFixed_intercept(random_intercept = FALSE)
}
\arguments{
\item{object}{expression that would be used in formula. E.g. \code{x} or \code{poly(x, degree = 3)}.}

\item{random_intercept}{\code{TRUE} if a zero mean time-varying process
should be included at as an additional term. Only relevant in stationary
models. See the \code{type} argument in \code{\link{PF_EM}}.}
}
\value{
Returns the passed object.
}
\description{
Functions used in formula of \code{\link{ddhazard}} for time-invariant effects. \code{ddFixed_intercept} is only used for the intercept.
}
\examples{
# we can get a time-invariant effect of `x1` by
set.seed(1)
dat <- data.frame(stop = 1:20, event = rep(c(TRUE, FALSE), 10L), x1 = rnorm(20))
ddhazard(Surv(stop, event) ~ ddFixed(x1), dat,
         Q_0 = diag(1), by = 1, Q = diag(1))

# all of the calls below will yield the same result with a time-invariant
# intercept:
ddhazard(Surv(stop, event) ~ ddFixed_intercept() + x1, dat,
         Q_0 = diag(1), by = 1, Q = diag(1))
ddhazard(Surv(stop, event) ~ -1 + ddFixed_intercept() + x1, dat,
         Q_0 = diag(1), by = 1, Q = diag(1))
}
