/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont2
extends DefinitionTag
implements SWFConstants {
    private int character;
    private boolean shiftJIS = false;
    private boolean ansi = false;
    private boolean wideOffsets = false;
    private boolean wideCodes = false;
    private boolean italic = false;
    private boolean bold = false;
    private int languageCode;
    private String name;
    private long[] offsets;
    private long codeOffset;
    private SWFShape[] shapes;
    private int[] codes;
    private int ascent;
    private int descent;
    private int leading;
    private short[] advances;
    private Rectangle2D[] bounds;
    private KerningRecord[] kerning = new KerningRecord[0];

    public DefineFont2() {
        super(48, 3);
    }

    public DefineFont2(int character, boolean italic, boolean bold, String name, SWFShape[] shapes, int[] codes) {
        this(character, false, false, italic, bold, true, true, 1, name, shapes, codes, 0, 0, 0, null, null, null);
    }

    public DefineFont2(int character, boolean shiftJIS, boolean ansi, boolean italic, boolean bold, boolean wideOffsets, boolean wideCodes, int languageCode, String name, SWFShape[] shapes, int[] codes, int ascent, int descent, int leading, short[] advances, Rectangle2D[] bounds, KerningRecord[] kerning) {
        this();
        this.character = character;
        this.shiftJIS = shiftJIS;
        this.ansi = ansi;
        this.italic = italic;
        this.bold = bold;
        this.wideOffsets = wideOffsets;
        this.wideCodes = wideCodes;
        this.languageCode = languageCode;
        this.name = name;
        this.shapes = shapes;
        this.codes = codes;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.advances = advances;
        this.bounds = bounds;
        this.kerning = kerning;
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        int i;
        DefineFont2 tag = new DefineFont2();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        boolean hasLayout = swf.readBitFlag();
        tag.shiftJIS = swf.readBitFlag();
        swf.readBitFlag();
        tag.ansi = swf.readBitFlag();
        tag.wideOffsets = swf.readBitFlag();
        tag.wideCodes = swf.readBitFlag();
        tag.italic = swf.readBitFlag();
        tag.bold = swf.readBitFlag();
        tag.languageCode = swf.readLanguageCode();
        int nameLength = swf.readUnsignedByte();
        tag.name = swf.getVersion() >= 6 ? swf.readUTF() : new String(swf.readByte(nameLength));
        int glyphCount = swf.readUnsignedShort();
        tag.offsets = new long[glyphCount];
        for (i = 0; i < glyphCount; ++i) {
            tag.offsets[i] = tag.wideOffsets ? swf.readUnsignedInt() : (long)swf.readUnsignedShort();
        }
        tag.codeOffset = tag.wideOffsets ? swf.readUnsignedInt() : (long)swf.readUnsignedShort();
        tag.shapes = new SWFShape[glyphCount];
        for (i = 0; i < glyphCount; ++i) {
            tag.shapes[i] = new SWFShape(swf);
        }
        int[] nArray = tag.codes = tag.wideCodes ? swf.readUnsignedShort(glyphCount) : swf.readUnsignedByte(glyphCount);
        if (hasLayout) {
            tag.ascent = swf.readShort();
            tag.descent = swf.readShort();
            tag.leading = swf.readShort();
            tag.advances = swf.readShort(glyphCount);
            tag.bounds = new Rectangle2D[glyphCount];
            for (i = 0; i < glyphCount; ++i) {
                tag.bounds[i] = swf.readRect();
            }
            int kerningCount = swf.readUnsignedShort();
            tag.kerning = new KerningRecord[kerningCount];
            for (int i2 = 0; i2 < kerningCount; ++i2) {
                tag.kerning[i2] = new KerningRecord(swf, tag.wideCodes);
            }
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        int i;
        boolean hasLayout = this.ascent != 0 || this.descent != 0 || this.leading != 0 || this.advances != null || this.bounds != null || this.kerning != null;
        swf.writeUnsignedShort(this.character);
        swf.writeBitFlag(hasLayout);
        swf.writeBitFlag(this.shiftJIS);
        swf.writeUBits(0L, 1);
        swf.writeBitFlag(this.ansi);
        swf.writeBitFlag(this.wideOffsets);
        swf.writeBitFlag(this.wideCodes);
        swf.writeBitFlag(this.italic);
        swf.writeBitFlag(this.bold);
        if (swf.getVersion() >= 6) {
            swf.writeLanguageCode(this.languageCode);
        } else {
            swf.writeUnsignedByte(0);
        }
        swf.writeUnsignedByte(this.name.length());
        if (swf.getVersion() >= 6) {
            swf.writeUTF(this.name);
        } else {
            swf.writeByte(this.name.getBytes());
        }
        swf.pushBuffer();
        int[] offsets = new int[this.shapes.length];
        int inc = this.wideOffsets ? 4 : 2;
        inc = (offsets.length + 1) * inc;
        for (i = 0; i < this.shapes.length; ++i) {
            offsets[i] = swf.getBufferLength() + inc;
            this.shapes[i].write(swf);
            swf.byteAlign();
        }
        this.codeOffset = swf.getBufferLength() + inc;
        swf.popBuffer();
        swf.writeUnsignedShort(offsets.length);
        for (i = 0; i < offsets.length; ++i) {
            if (this.wideOffsets) {
                swf.writeUnsignedInt(offsets[i]);
                continue;
            }
            swf.writeUnsignedShort(offsets[i]);
        }
        if (this.wideOffsets) {
            swf.writeUnsignedInt(this.codeOffset);
        } else {
            swf.writeUnsignedShort((int)this.codeOffset);
        }
        swf.append();
        if (this.wideCodes) {
            for (i = 0; i < offsets.length; ++i) {
                swf.writeUnsignedShort(this.codes[i]);
            }
        } else {
            for (i = 0; i < offsets.length; ++i) {
                swf.writeUnsignedByte(this.codes[i]);
            }
        }
        if (hasLayout) {
            swf.writeShort(this.ascent);
            swf.writeShort(this.descent);
            swf.writeShort(this.leading);
            for (i = 0; i < offsets.length; ++i) {
                swf.writeShort(this.advances[i]);
            }
            for (i = 0; i < this.bounds.length; ++i) {
                swf.writeRect(this.bounds[i]);
            }
            swf.writeUnsignedShort(this.kerning.length);
            for (i = 0; i < this.kerning.length; ++i) {
                this.kerning[i].write(swf, this.wideCodes);
            }
        }
    }

    public long getId() {
        return this.character;
    }

    public boolean getShiftJIS() {
        return this.shiftJIS;
    }

    public boolean isAnsi() {
        return this.ansi;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean hasWideOffsets() {
        return this.wideOffsets;
    }

    public boolean hasWideCodes() {
        return this.wideCodes;
    }

    public String getName() {
        return this.name;
    }

    public SWFShape[] getShapes() {
        return this.shapes;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public short[] getAdvances() {
        return this.advances;
    }

    public Rectangle2D[] getBounds() {
        return this.bounds;
    }

    public KerningRecord[] getKerning() {
        return this.kerning;
    }

    public void setId(int id) {
        this.character = id;
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
    }

    public void setAnsi(boolean ansi) {
        this.ansi = ansi;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setWideOffsets(boolean wideOffsets) {
        this.wideOffsets = wideOffsets;
    }

    public void setWideCodes(boolean wideCodes) {
        this.wideCodes = wideCodes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCodes(int[] codes) {
        this.codes = codes;
    }

    public void setShapes(SWFShape[] shapes) {
        this.shapes = shapes;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public void setAdvances(short[] advances) {
        this.advances = advances;
    }

    public void setAdvances(int[] advances) {
        short[] s = new short[advances.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = (short)advances[i];
        }
        this.setAdvances(s);
    }

    public void setBounds(Rectangle2D[] bounds) {
        this.bounds = bounds;
    }

    public void setKerning(KerningRecord[] kerning) {
        this.kerning = kerning;
    }

    public String toString() {
        int i;
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  name: " + this.name + "\n");
        if (this.shiftJIS) {
            s.append("  shiftJIS\n");
        }
        if (this.ansi) {
            s.append("  ansi\n");
        }
        if (this.italic) {
            s.append("  italic\n");
        }
        if (this.bold) {
            s.append("  bold\n");
        }
        if (this.wideOffsets) {
            s.append("  wideOffsets\n");
        }
        if (this.wideCodes) {
            s.append("  wideCodes\n");
        }
        if (this.languageCode > 0) {
            s.append("  languageCode: " + this.languageCode + "\n");
        }
        if (this.ascent != 0) {
            s.append("  ascent: " + this.ascent + "\n");
        }
        if (this.descent != 0) {
            s.append("  descent: " + this.descent + "\n");
        }
        if (this.leading != 0) {
            s.append("  leading: " + this.leading + "\n");
        }
        if (this.advances != null) {
            for (i = 0; i < this.advances.length; ++i) {
                s.append("  advances[" + i + "]: " + this.advances[i] + "\n");
            }
        }
        if (this.bounds != null) {
            for (i = 0; i < this.bounds.length; ++i) {
                s.append("  bounds[" + i + "]: " + this.bounds[i] + "\n");
            }
        }
        s.append("  glyphCount: " + this.shapes.length + "\n");
        for (i = 0; i < this.shapes.length; ++i) {
            s.append("  >>> Shape " + i + "\n");
            s.append(this.shapes[i] + "\n");
        }
        return s.toString();
    }

    public static class KerningRecord {
        private int code1;
        private int code2;
        private int adjustment;

        public KerningRecord(int code1, int code2, int adjustment) {
            this.code1 = code1;
            this.code2 = code2;
            this.adjustment = adjustment;
        }

        public KerningRecord(SWFInputStream input, boolean wideCodes) throws IOException {
            this.code1 = wideCodes ? input.readUnsignedShort() : input.readUnsignedByte();
            this.code2 = wideCodes ? input.readUnsignedShort() : input.readUnsignedByte();
            this.adjustment = input.readShort();
        }

        public void write(SWFOutputStream swf, boolean wideCodes) throws IOException {
            if (wideCodes) {
                swf.writeUnsignedShort(this.code1);
            } else {
                swf.writeUnsignedByte(this.code1);
            }
            if (wideCodes) {
                swf.writeUnsignedShort(this.code2);
            } else {
                swf.writeUnsignedByte(this.code2);
            }
            swf.writeShort(this.adjustment);
        }

        public String toString() {
            return "Kerning[" + this.code1 + ", " + this.code2 + ", " + this.adjustment + "]";
        }
    }
}

