/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.CommandTargetManager;
import jas.util.ErrorBox;
import jas.util.GetOptions;
import jas.util.HelpInterface;
import jas.util.UserProperties;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class Application
extends JPanel {
    private CommandTargetManager m_commandTargetManager = new CommandTargetManager();
    private Vector theHelpLocations = new Vector();
    private static Application app = null;
    private boolean debugHelp = false;
    private JFrame m_parent;
    private final UserProperties m_prop = new UserProperties();
    private GetOptions gopt = new GetOptions();
    private HelpInterface hi = null;

    public Application() {
        super(new BorderLayout());
        if (app != null) {
            throw new RuntimeException("Cannot make two applications.");
        }
        app = this;
        this.gopt.addOption("debug", 'd', false, "Takes a : separated list of debug modes to set");
        this.gopt.addOption("help", 'h', true, "Print this message");
        ActionListener helpListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Application.this.showHelpContents();
            }
        };
        this.registerKeyboardAction(helpListener, KeyStroke.getKeyStroke(156, 0), 2);
        this.registerKeyboardAction(helpListener, KeyStroke.getKeyStroke(112, 0), 2);
    }

    protected int parseArgs(String[] argv) {
        try {
            this.gopt.parseArgs(argv);
        }
        catch (GetOptions.BadArguments x) {
            this.doHelp();
            System.out.println("The command line options you specified had the following problem:\n" + x.getMessage());
            System.exit(0);
        }
        if (this.gopt.hasOption("help")) {
            this.doHelp();
            System.exit(0);
        }
        this.setDebugFlags();
        return this.gopt.numParams();
    }

    protected void doHelp() {
        this.gopt.dumpOptions();
    }

    private void initializeHelpSystem() throws Exception {
        if (this.debugHelp) {
            System.err.println("Initializing help system...");
        }
        try {
            this.hi = (HelpInterface)Class.forName("jas.util.HelpInterfaceImpl").newInstance();
            if (this.debugHelp) {
                System.err.println("Help system initialized successfully");
            }
        }
        catch (Exception x) {
            if (this.debugHelp) {
                System.err.println("Failed: " + x.getMessage());
            }
            throw x;
        }
    }

    public void addHelpLocation(Class base, String s) {
        this.addHelpLocation(base.getResource(s));
    }

    public void addHelpLocation(URL url) {
        if (this.debugHelp) {
            System.err.println("addHelpLocation: " + url);
        }
        if (url != null) {
            this.theHelpLocations.addElement(url);
        }
    }

    public void addHelpLocation(String s) {
        try {
            if (this.debugHelp) {
                System.err.println("addHelpLocation: " + s);
            }
            this.theHelpLocations.addElement(new URL(s));
        }
        catch (MalformedURLException x) {
            System.err.println("Bad URL for addHelpLocation - ignored: " + s);
            x.printStackTrace();
        }
    }

    Enumeration getHelpLocations() {
        return this.theHelpLocations.elements();
    }

    private void setDebugFlags() {
        if (this.gopt.hasOption("debug")) {
            StringTokenizer st = new StringTokenizer(this.gopt.getOption("debug"), ":");
            while (st.hasMoreTokens()) {
                this.setDebugFlag(st.nextToken());
            }
        }
    }

    protected void setDebugFlag(String flag) {
        String name = "debug" + flag.substring(0, 1).toUpperCase() + flag.substring(1);
        System.getProperties().put(name, "true");
        System.out.println("Set debug flag " + name);
        if (flag.equals("help")) {
            this.debugHelp = true;
        }
    }

    public static final Application getApplication() {
        return app;
    }

    public final UserProperties getUserProperties() {
        return this.m_prop;
    }

    public final JFrame getFrame() {
        if (this.m_parent == null) {
            Container parent;
            for (parent = this; parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
            }
            this.m_parent = (JFrame)parent;
        }
        return this.m_parent;
    }

    public final void showHelpContents() {
        this.showHelpTopic("top");
    }

    public final void showHelpIndex() {
        this.showHelpTopic("top", "Index");
    }

    public final void showHelpSearch() {
        this.showHelpTopic("top", "Search");
    }

    public final void error(String s, Throwable t) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), s, t).doModal();
        } else {
            System.err.println("Error: " + s + " " + t);
        }
    }

    public final void error(String s) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), s).doModal();
        } else {
            System.err.println("Error: " + s);
        }
    }

    public final void error(String s, Throwable t, String helpTopic) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), s, t, helpTopic).doModal();
        } else {
            System.err.println("Error: " + s + " " + t);
        }
    }

    public final void error(String s, String helpTopic) {
        if (this.getFrame() != null) {
            new ErrorBox(this.getFrame(), s, helpTopic).doModal();
        } else {
            System.err.println("Error: " + s);
        }
    }

    public final void showHelpTopic(String helpTopicTarget) {
        this.showHelpTopic(helpTopicTarget, this.getFrame());
    }

    public final void showHelpTopic(String helpTopicTarget, Window owner) {
        try {
            if (this.hi == null) {
                this.initializeHelpSystem();
            }
            this.hi.showHelpTopic(helpTopicTarget, owner);
        }
        catch (Throwable eek) {
            this.whine(eek);
        }
    }

    private final void showHelpTopic(String helpTopicTarget, String navigatorView) {
        try {
            if (this.hi == null) {
                this.initializeHelpSystem();
            }
            this.hi.showHelpTopic(helpTopicTarget, navigatorView, this.getFrame());
        }
        catch (Throwable eek) {
            this.whine(eek);
        }
    }

    private final void whine(Throwable eek) {
        app.error("Could not initialize help system!", eek);
    }

    public GetOptions getGetOptions() {
        return this.gopt;
    }

    public CommandTargetManager getCommandManager() {
        return this.m_commandTargetManager;
    }

    void modalDialogOpening(Dialog dlg) {
        if (this.hi != null) {
            this.hi.modalDialogOpening(dlg);
        }
    }

    void modalDialogClosing(Dialog dlg) {
        if (this.hi != null) {
            this.hi.modalDialogClosing(dlg);
        }
    }
}

