/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.ContinueAnalysee;
import don.DonneeParse;
import don.Nominale;
import don.Qualifiable;
import don.Variable;
import ihm.IHM;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import outils.Constantes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FenetreDescriptionContinue
extends JDialog {
    private JPanel jPanel = null;
    private JLabel jLabelContinues = null;
    private JScrollPane jScrollPaneContinues = null;
    private JList jListContinues = null;
    private JLabel jLabelNominales = null;
    private JScrollPane jScrollPaneNominales = null;
    private JList jListNominales = null;
    private DonneeParse m_don;
    private Qualifiable m_quali;
    private static HashMap<Qualifiable, FenetreDescriptionContinue> m_fenetres;

    private FenetreDescriptionContinue(Frame arg0, DonneeParse don, Qualifiable qualifiable) throws HeadlessException {
        super(arg0, String.valueOf(IHM.getXmlLangue().getElement("LDescription")) + qualifiable.getAnnotation());
        this.m_don = don;
        this.m_quali = qualifiable;
        this.initialize();
    }

    public static void montrer(Frame frame, DonneeParse don, Qualifiable qualifiable) {
        if (m_fenetres == null) {
            m_fenetres = new HashMap();
        }
        if (m_fenetres.get(qualifiable) == null || !m_fenetres.get(qualifiable).isVisible()) {
            m_fenetres.put(qualifiable, new FenetreDescriptionContinue(frame, don, qualifiable));
        }
        m_fenetres.get(qualifiable).setVisible(true);
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(null);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabelNominales = new JLabel();
            this.jLabelNominales.setText(String.valueOf(IHM.getXmlLangue().getElement("LNominale")) + " :");
            this.jLabelContinues = new JLabel();
            this.jLabelContinues.setText(String.valueOf(IHM.getXmlLangue().getElement("LContinue")) + " :");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbcpanel = new GridBagConstraints();
            gbcpanel.gridx = 0;
            gbcpanel.gridy = -1;
            gbcpanel.fill = 2;
            gbcpanel.insets = new Insets(0, 15, 15, 15);
            GridBagConstraints gbcLabel = new GridBagConstraints();
            gbcLabel.gridx = 0;
            gbcLabel.gridy = -1;
            gbcLabel.fill = 2;
            gbcLabel.insets = new Insets(0, 15, 0, 15);
            this.jPanel.add((Component)this.jLabelContinues, gbcLabel);
            this.jPanel.add((Component)this.getJScrollPaneContinues(), gbcpanel);
            this.jPanel.add((Component)this.jLabelNominales, gbcLabel);
            this.jPanel.add((Component)this.getJScrollPaneNominales(), gbcpanel);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPaneContinues() {
        if (this.jScrollPaneContinues == null) {
            this.jScrollPaneContinues = new JScrollPane();
            this.jScrollPaneContinues.setViewportView(this.getJListContinues());
        }
        return this.jScrollPaneContinues;
    }

    private JList getJListContinues() {
        if (this.jListContinues == null) {
            this.jListContinues = new JList();
            TreeSet<Object> vect = new TreeSet<Object>(this.getComparateur());
            vect.addAll(this.m_don.getVariablesMoyennes());
            vect.remove(this.m_quali);
            this.jListContinues.setListData(vect.toArray());
            this.jListContinues.setCellRenderer(new DescriptionCellRenderer(this.m_quali));
        }
        return this.jListContinues;
    }

    private JScrollPane getJScrollPaneNominales() {
        if (this.jScrollPaneNominales == null) {
            this.jScrollPaneNominales = new JScrollPane();
            this.jScrollPaneNominales.setViewportView(this.getJListNominales());
        }
        return this.jScrollPaneNominales;
    }

    private JList getJListNominales() {
        if (this.jListNominales == null) {
            this.jListNominales = new JList();
            TreeSet<Object> vect = new TreeSet<Object>(this.getComparateur());
            vect.addAll(this.m_don.getNominales());
            vect.remove(this.m_quali);
            this.jListNominales.setListData(vect.toArray());
            this.jListNominales.setCellRenderer(new DescriptionCellRenderer(this.m_quali));
        }
        return this.jListNominales;
    }

    protected Comparator<Object> getComparateur() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                double val = 0.0;
                if (arg0 instanceof Nominale && arg1 instanceof Nominale) {
                    val = Math.abs(FenetreDescriptionContinue.this.m_quali.getDescNom((Nominale)arg0)) - Math.abs(FenetreDescriptionContinue.this.m_quali.getDescNom((Nominale)arg1));
                } else if (arg0 instanceof ContinueAnalysee && arg1 instanceof ContinueAnalysee) {
                    val = Math.abs(FenetreDescriptionContinue.this.m_quali.getDescCont((ContinueAnalysee)arg0)) - Math.abs(FenetreDescriptionContinue.this.m_quali.getDescCont((ContinueAnalysee)arg1));
                }
                if (arg0.equals(arg1)) {
                    return 0;
                }
                if (val > 0.0) {
                    return 1;
                }
                return -1;
            }
        };
    }

    private class DescriptionCellRenderer
    implements ListCellRenderer {
        private Qualifiable m_qualiRenderer;

        public DescriptionCellRenderer(Qualifiable quali) {
            this.m_qualiRenderer = quali;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof Nominale) {
                Nominale nom = (Nominale)value;
                return this.getLabel(nom, this.m_qualiRenderer.getDescNom(nom));
            }
            if (value instanceof ContinueAnalysee) {
                ContinueAnalysee cont = (ContinueAnalysee)value;
                return this.getLabel(cont, this.m_qualiRenderer.getDescCont(cont));
            }
            return new JLabel("*error");
        }

        private Component getLabel(Variable var, double val) {
            JLabel label = new JLabel(var.getAnnotation());
            if (val > 0.0 && val < 0.05) {
                label.setForeground(Constantes.COULEUR_HABILLAGE_CONTINUE_POSITIF);
            } else if (val < 0.0 && val > -0.05) {
                label.setForeground(Constantes.COULEUR_HABILLAGE_CONTINUE_NEGATIF);
            } else {
                label.setForeground(Constantes.COULEUR_HABILLAGE_CONTINUE_ZERO);
            }
            return label;
        }
    }
}

