/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Critere;
import criteres.CritereActifIllustratif;
import criteres.CritereGeneration;
import criteres.CritereTypeDeDonnee;
import criteres.Info;
import criteres.Paire;
import criteres.Qualificatif;
import criteres.Singleton;
import don.DonneeID;
import don.Individu;
import ihm.IHM;

public class CritereCompose
extends Qualificatif {
    protected Critere m_critere1;
    protected Critere m_critere2;

    public CritereCompose() {
        this.m_critere1 = null;
        this.m_critere2 = null;
    }

    public CritereCompose(Critere critere1, Critere critere2) {
        this.m_critere1 = critere1;
        this.m_critere2 = critere2;
    }

    public void addCritere(Critere critere) {
        if (this.m_critere1 == null) {
            this.m_critere1 = critere;
        } else {
            this.m_critere2 = this.m_critere2 == null ? critere : new CritereCompose(critere, this.m_critere2);
        }
    }

    public Critere getCritere1() {
        return this.m_critere1;
    }

    public Critere getCritere2() {
        return this.m_critere2;
    }

    public Info evaluer(DonneeID obj) {
        Info val1 = this.m_critere1.evaluer(obj);
        if (this.m_critere2 != null) {
            Info val2 = this.m_critere2.evaluer(obj);
            if (val1.isError() && val2.isError()) {
                return new Singleton(Integer.MAX_VALUE);
            }
            return new Paire(val1, val2);
        }
        return val1;
    }

    public String semantique() {
        if (this.m_critere1 != null && this.m_critere2 != null) {
            return "(" + this.m_critere1.semantique() + " " + IHM.getXmlLangue().getElement("ou") + " " + this.m_critere2.semantique() + ")";
        }
        if (this.m_critere1 != null) {
            return this.m_critere1.semantique();
        }
        return this.m_critere2.semantique();
    }

    public int getNbSeries() {
        int nb = 1;
        if (this.m_critere1 != null) {
            nb *= this.m_critere1.getNbSeries();
        }
        if (this.m_critere2 != null) {
            nb *= this.m_critere2.getNbSeries();
        }
        return nb;
    }

    public String semantique(Paire i) {
        String chaineB;
        String chaineA;
        if (IHM.getXmlLangue().adjectifsAvant()) {
            if (this.m_critere1.adjectif()) {
                chaineA = this.m_critere1.semantique(i.getG());
                chaineB = this.m_critere2.semantique(i.getD());
            } else {
                chaineA = this.m_critere2.semantique(i.getD());
                chaineB = this.m_critere1.semantique(i.getG());
            }
        } else if (!this.m_critere1.adjectif()) {
            chaineA = this.m_critere1.semantique(i.getG());
            chaineB = this.m_critere2.semantique(i.getD());
        } else {
            chaineA = this.m_critere2.semantique(i.getD());
            chaineB = this.m_critere1.semantique(i.getG());
        }
        if (chaineB.equals("")) {
            return chaineA;
        }
        if (chaineA.equals("")) {
            return chaineB;
        }
        return String.valueOf(chaineA) + " " + chaineB;
    }

    public String semantique(Singleton i) {
        if (this.m_critere2 == null && this.m_critere1 != null) {
            return this.m_critere1.semantique(i);
        }
        if (this.m_critere1 == null && this.m_critere2 != null) {
            return this.m_critere2.semantique(i);
        }
        return "erreur (critere) singleton au lieu de paire pour compos\u00e9";
    }

    public String semantique(Info i) {
        if (this.m_critere2 != null && i instanceof Paire) {
            return this.semantique((Paire)i);
        }
        return this.m_critere1.semantique(i);
    }

    public boolean adjectif() {
        if (this.m_critere1 != null && this.m_critere2 != null) {
            return this.m_critere1.adjectif() && this.m_critere2.adjectif();
        }
        if (this.m_critere1 != null) {
            return this.m_critere1.adjectif();
        }
        if (this.m_critere2 != null) {
            return this.m_critere2.adjectif();
        }
        return false;
    }

    public static void main(String[] args) {
        Individu ind = new Individu("ind", true, null, null, null, null, null);
        ind.setGeneration(3);
        CritereCompose crit = new CritereCompose();
        CritereTypeDeDonnee c3 = new CritereTypeDeDonnee();
        crit.addCritere(c3);
        System.out.println(c3.evaluer(ind));
        CritereActifIllustratif c1 = new CritereActifIllustratif();
        crit.addCritere(c1);
        System.out.println(c1.evaluer(ind));
        CritereGeneration c2 = new CritereGeneration();
        crit.addCritere(c2);
        System.out.println(c2.evaluer(ind));
        System.out.println(crit.evaluer(ind));
        System.out.println(crit.qualifier(ind));
    }

    public int compare(Paire i0, Paire i1) {
        int res1 = this.m_critere1.compare(i0.getG(), i1.getG());
        if (res1 != 0 || this.m_critere2 == null) {
            return res1;
        }
        int res2 = this.m_critere2.compare(i0.getD(), i1.getD());
        return res2;
    }
}

