/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.config;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public class PropertyFileConfiguration
extends HierarchicalConfiguration {
    private static final long serialVersionUID = -8520340881666124933L;

    public void load(String resourceName) {
        InputStream in = ObjectUtilities.getResourceRelativeAsStream(resourceName, PropertyFileConfiguration.class);
        if (in != null) {
            this.load(in);
        } else {
            Log.debug("Configuration file not found in the classpath: " + resourceName);
        }
    }

    public void load(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        try {
            BufferedInputStream bin = new BufferedInputStream(in);
            Properties p = new Properties();
            p.load(bin);
            this.getConfiguration().putAll((Map<?, ?>)p);
            bin.close();
        }
        catch (IOException ioe) {
            Log.warn("Unable to read configuration", ioe);
        }
    }
}

