% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Interpol.R
\name{interpol}
\alias{interpol}
\title{Interpolation of DYRESM-CAEDYM simulation results
across a series of user-defined depths.}
\usage{
interpol(layerHeights, var, min.depth, max.depth, by.value)
}
\arguments{
\item{layerHeights}{layer heights, outputs from a DYRESM-CAEDYM model run,
and can be generated with the 'ext_output' function.}

\item{var}{simulation results of a water quality variable and can also be
generated with the 'ext_output' function.}

\item{min.depth, max.depth, by.value}{minimum and maximum layer depths within
which interpolation will be conducted. by.value sets up the depth increments
between two immediate layers.}
}
\value{
a matrix of interpolated values of the water quality variable(s).
}
\description{
The default simulation results of a water quality variable from
DYRESM-CAEDYM are usually at irregular layer heights.
This function convert it to a data frame with regular layer heights through
interpolation.
}
\examples{
# extract simulated temperature values from DYRESM-CAEDYM simulation file
 var.values<-ext_output(dycd.output=system.file("extdata", "dysim.nc",
                                                 package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in seq_along(var.values)){
  expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
  eval(parse(text=expres))
 }

 # interpolate temperature for depths from 0 to 13 m at increment of 0.5 m
 temp.interpolated<-interpol(layerHeights = dyresmLAYER_HTS_Var,
                            var = dyresmTEMPTURE_Var,
                            min.dept = 0,
                            max.dept = 13,
                            by.value = 0.5)

}
