% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{ddCI}
\alias{ddCI}
\title{Calculate CI for CDF, PDF, or quantile}
\usage{
ddCI(
  mod,
  x,
  type = "CDF",
  CL = 0.9,
  nsim = 1000,
  extent = "full",
  zrad = 200,
  na.tol = 0.1
)
}
\arguments{
\item{mod}{a \code{\link[=ddFit]{dd}} object}

\item{x}{distance from turbine (scalar or vector) or probability (for quantile)}

\item{type}{\code{"CDF"}, \code{"PDF"}, or \code{"quantile"}}

\item{CL}{confidence level for the confidence interval(s)}

\item{nsim}{number of simulation draws to base the estimate of \code{CI} on}

\item{extent}{whether to calculate \code{CI} based on the full range of
possible data and extrapolating beyond the search radius
(\code{extent = "full"}) or restricting the distribution to the area within
the search radius (\code{extent = "win"}).}

\item{zrad}{an ad hoc radius to integrate to when the (uncommon) simulated
parameter estimates do not result in an extensible distribution. In effect,
This replaces NAs with 1s in CDFs and with 0s in PDFs.}

\item{na.tol}{maximum fraction of invalid parameter sets to discard when
constructing CIs; abort if \code{mean(mod[, "extensible"]) > na.tol}}
}
\value{
array (\code{ddCI} class) with columns for distance and the CI bounds
}
\description{
Calculate a confidence interval for the CDF, PDF, or quantile of a carcass
distance distribution.
}
