% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generatePairings.R
\name{generatePairings}
\alias{generatePairings}
\title{Sex-consistent pairings}
\usage{
generatePairings(dvi, includeEmpty = TRUE, ignoreSex = FALSE)
}
\arguments{
\item{dvi}{A \code{dviData} object, typically created with \code{\link[=dviData]{dviData()}}.}

\item{includeEmpty}{A logical. If TRUE (default), the do-nothing symbol (\code{*})
is included for each victim.}

\item{ignoreSex}{A logical.}
}
\value{
A list of character vectors. Each vector is a subset of \code{missing},
plus the character \code{*} denoting no pairing.
}
\description{
Generate a list of sex-consistent pairings for each victim in a DVI problem.
By default, the empty pairing (denoted \code{*}) is included for each victim.
}
\examples{

pm = list(singleton("V1", sex = 1),
          singleton("V2", sex = 2))
          
missing = paste0("M", 1:4)
am = list(nuclearPed(children = missing[1:3]),
          nuclearPed(children = missing[4], sex = 2))

dvi = dviData(pm, am, missing)
generatePairings(dvi)

}
\seealso{
\code{\link[=jointDVI]{jointDVI()}}
}
