% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot.R
\name{poly_pivot_wider}
\alias{poly_pivot_wider}
\title{Transforming data.frame with multiple Data Column into Wide Format}
\usage{
poly_pivot_wider(
  data,
  id,
  param_from,
  value_from,
  labels_from = NULL,
  drop_na = TRUE,
  drop_lvl = FALSE
)
}
\arguments{
\item{data}{(\code{data.frame}) to be pivoted.}

\item{id}{(\code{character}) the name of the columns whose combination uniquely identify the observations.}

\item{param_from}{(\code{character}) the name of the columns containing the names of the parameters to be pivoted. The
unique values in this column will become column names in the output.}

\item{value_from}{(\code{character}) the name of the column containing the values that will populate the output.}

\item{labels_from}{(\code{character}) the name of the column congaing the labels of the new columns. from. If not
provided, the labels will be equal to the column names. When several labels are available for the same column, the
first one will be selected.}

\item{drop_na}{(\code{logical}) should column containing only \code{NAs} be dropped.}

\item{drop_lvl}{(\code{logical}) should missing levels be dropped in the columns coming from \code{value_from}.}
}
\value{
\code{list} of \code{data.frame} in a wide format with label attribute attached to each columns.
}
\description{
Transforming data.frame with multiple Data Column into Wide Format
}
\details{
This function is adapted to cases where the data are distributed in several columns while the name of the
parameter is in one. Typical example is \code{adsub} where numeric data are stored in \code{AVAL} while categorical data are
in \code{AVALC}.
}
\examples{
test_data <- data.frame(
  the_obs = c("A", "A", "A", "B", "B", "B", "C", "D"),
  the_obs2 = c("Ax", "Ax", "Ax", "Bx", "Bx", "Bx", "Cx", "Dx"),
  the_param = c("weight", "height", "gender", "weight", "gender", "height", "height", "other"),
  the_label = c(
    "Weight (Kg)", "Height (cm)", "Gender", "Weight (Kg)",
    "Gender", "Height (cm)", "Height (cm)", "Pre-condition"
  ),
  the_val = c(65, 165, NA, 66, NA, 166, 155, NA),
  the_val2 = c(65, 165, "M", 66, "F", 166, 155, TRUE)
)

x <- poly_pivot_wider(
  test_data,
  c("the_obs", "the_obs2"),
  "the_param",
  c("the_val", "the_val2"),
  "the_label"
)
x
Reduce(function(u, v) merge(u, v, all = TRUE), x)
}
