% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hyperbolic.R
\docType{methods}
\name{Hyperbolic}
\alias{Hyperbolic}
\alias{cosh,dual-method}
\alias{sinh,dual-method}
\alias{tanh,dual-method}
\alias{acosh,dual-method}
\alias{asinh,dual-method}
\alias{atanh,dual-method}
\title{Hyperbolic Functions}
\usage{
\S4method{cosh}{dual}(x)

\S4method{sinh}{dual}(x)

\S4method{tanh}{dual}(x)

\S4method{acosh}{dual}(x)

\S4method{asinh}{dual}(x)

\S4method{atanh}{dual}(x)
}
\arguments{
\item{x}{a dual object}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
These functions provide the obvious hyperbolic functions. 
They respectively compute the hyperbolic cosine, sine, tangent, 
and their inverses, arc-cosine, arc-sine, arc-tangent.
}
\examples{
x <- dual(0.5, 1)
cosh(x)
sinh(x)
tanh(x)
acosh(1 + x)
asinh(x)
atanh(x)

}
