% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdtw-cent.R
\name{sdtw_cent}
\alias{sdtw_cent}
\title{Centroid calculation based on soft-DTW}
\usage{
sdtw_cent(series, centroid = NULL, gamma = 0.01, weights = rep(1,
  length(series)), ..., opts = list(algorithm = "NLOPT_LD_LBFGS", maxeval =
  20L), error.check = TRUE, cm = NULL, dm = NULL, em = NULL)
}
\arguments{
\item{series}{A matrix or data frame where each row is a time series, or a list where each
element is a time series. Multivariate series should be provided as a list of matrices where
time spans the rows and the variables span the columns of each matrix.}

\item{centroid}{Optionally, a time series to use as reference. Defaults to a random series of
\code{series} if \code{NULL}. For multivariate series, this should be a matrix with the same
characteristics as the matrices in \code{series}.}

\item{gamma}{Positive regularization parameter, with lower values resulting in less smoothing.}

\item{weights}{A vector of weights for each element of \code{series}.}

\item{...}{Further arguments for \code{\link[nloptr:nloptr]{nloptr::nloptr()}} (except \code{opts}).}

\item{opts}{List of options to pass to \code{\link[nloptr:nloptr]{nloptr::nloptr()}}.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}

\item{cm, dm, em}{Optional helper matrices for the calculations. Used internally for memory
optimization. If provided, they \strong{will} be modified \emph{in place} by \code{C} code. See details for
dimensioning information.}
}
\value{
The resulting centroid, with attribute \code{nloptr_results} specifying the optimization
results (except for \code{solution}, which is the returned centroid).
}
\description{
Soft-DTW centroid function as proposed in Cuturi and Blondel (2017).
}
\details{
The helper matrices are allocated in the following way by default:\preformatted{num_rows <- NROW(centroid)
num_cols <- max(sapply(series, NROW))
cm <- matrix(0, num_rows + 2L, num_cols + 2L)
dm <- matrix(0, num_rows + 1L, num_cols + 1L)
em <- matrix(0, 2L, num_cols + 2L)
}

Note that you can trace the optimization by specifing \code{print_level > 0} in \code{opts}.
}
\references{
Cuturi, M., & Blondel, M. (2017). Soft-DTW: a Differentiable Loss Function for Time-Series. arXiv
preprint arXiv:1703.01541.
}
